<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file DeleteScaffold.php
 * @brief table manager page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: DeleteScaffoldForeperson.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once("ficus/pages/AbstractPage.php");
require_once("ficus/config/Registry.php");
require_once("ficus/db/s2dao/models/serializer/S2DaoS2DaoArrayEntityDeserializer.php");
require_once("common/AbstractPage.php");

/**
 * @class Ficus_DeleteScaffold
 */
class Ficus_DeleteScaffold extends Ficus_AbstractScaffold
    /**
     * delete
     * @param $args array of arguments
     */
    public function doDelete($args){
        $ids = $this->extractArgument($args, "targets");
        $entities = $this->getEntities($ids);

        $container = $this->getContainer($entities);

        $organizer = $this->getListOrganizer();
        $organizer->setItemTemplate("item");
        $organizer->setRowTemplate("row");
        $organizer->setHeaderTemplate("header");
        $organizer->setEntityTemplate("table");
        $container->addOrganizers($organizer);

        $this->assign("ids", $ids);
        $this->assignReference("container", $container);
        $this->setNextAction("deleteSubmit");
        return self::MODE_TEMPLATE;
    }
    
    /**
     * delete
     * @param $args array of arguments
     */
    public function doDeleteSubmit($args){
        $ids = $this->extractArgument($args, "targets");

        $entity = $this->dao->entity();
        foreach($ids as $id){
            $entity->setId($id);
            $this->dao->delete($entity);
        }

        $this->assign("ids", $ids);
        return self::MODE_TEMPLATE;
    }
}    
?>
