<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file PageRequest.php
 * @brief request wrapper
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PageRequest.php 2 2007-07-11 10:37:48Z ishitoya $
 */

/**
 * @class Ficus_PageRequest
 */
class Ficus_PageRequest extends Ficus_Bean{
    protected $post = array();
    protected $get = array();
    protected $requests = array();

    /**
     * construct
     */
    public function __construct($args = array()){
        $this->post = $_POST;
        $this->get = $_GET;
        $this->requests = $this->createArguments($args);
    }

    /**
     * create args
     * merge post, get and drop filename
     * @param $args array of argument
     * @return Array of arguments
     */
    protected function createArguments($args){
        $request = array_merge($_POST, $_GET);
        array_shift($args);
        array_shift($args);
        array_shift($args);
        $result = array();
        foreach($args as $arg){
            if(is_array($arg)){
                $result[key($arg)] = $arg[key($arg)];
            }
        }
        foreach($request as $key => $arg){
            $result[$key] = $arg;
        }
        return $result;
    }

    /**
     * extract 
     * @param $args array of arguments
     * @param $name string name of the argument
     * @param $type string type of the argument
     * @return integer id
     */
    protected function extract($name, $type = "int"){
        $args = $this->requests;
        if(isset($args[$name]) == false){
            return null;
        }
        
        $argument = $args[$name];
        if(is_string($argument)){
            $argument = trim($argument);
            $argument = Ficus_Types::cast($argument, $type);
            Ficus_Assert::isPrimitiveType($argument, $type);
        }else if(is_array($argument)){
            foreach($argument as $key => $value){
                $value = trim($value);
                $value = Ficus_Types::cast($value, $type);

                Ficus_Assert::isPrimitiveType($value, $type);
                $argument[$key] = $value;
            }
        }
        return $argument;
    }

    /**
     * has
     */
    public function has($name){
        return isset($this->requests[$name]);
    }
        

    /**
     * call
     */
    public function __call($name, $arguments){
        if(preg_match('/^extractAs(.*)$/', $name, $regs)){
            $type = strtolower(trim($regs[1]));
            return $this->extract($arguments[0], $type);
        }else if(preg_match('/^has(.*?)$/', $name, $regs)){
            $string = new Ficus_String($regs[1]);
            $name = $string->lowerCaseFirst();
            $name = $name->__toString();
            return $this->has($name);
        }
        return parent::__call($name, $arguments);
    }
}
?>
