<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file AbstractPage.php
 * @brief abstract Page
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AbstractPage.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once("ficus/pages/Page.php");
require_once("ficus/exception/IllegalArgumentException.php");

/**
 * @class Ficus_AbstractPage
 */
abstract class Ficus_AbstractPage extends Ficus_Page{
    /**
     * constructor
     */
    protected function onConstruct(){
    }
    
    /**
     * get default mode
     * @return string default mode name
     */
    public function getDefaultMode(){
        return self::PAGE_DEFAULT_MODE;
    }

    /**
     * on called
     * @param $mode string name of mode
     * @param $args array of args of do method
     */
    protected function onDo($mode, $args){
        $this->setNextAction(self::PAGE_DEFAULT_MODE);
    }

    /**
     * on exception
     * @param $mode string name of mode
     * @param $args array of args of do method
     * @param $exception Exception exception
     */
    protected function onException($mode, $args, $exception){
        $template = Ficus_Registry::search(self::REGISTRY_EXCEPTION_TEMPLATE);
        if($template){
            $this->display($template);
        }else{
            $this->display(self::DEFAULT_EXCEPTION_TEMPLATE);
        }
    }

    /**
     * on authorization
     */
    protected function onAuthorization(){
        return self::AUTHORIZATION_NOT_REQUIRED;
    }

    /**
     * show default
     */
    public function doDefault(){
    }
}
?>