<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.XML
 */
/**
 * @file Unicode.php
 * @brief Unicode.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: Unicode.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 */
/**
 * @class Ficus_Unicode
 */
class Ficus_Unicode
{
    /**
     * UTF-8
     */
    const UTF8 = 'UTF-8';

    /**
     * UTF-16
     */
    const UTF16 = 'UTF-16';

    /**
     * UCS-4
     */
    const UCS4 = 'UCS-4';

    /**
     * Get Unicode number from unicode encoding.
     *
     * @param $utf string unicode encoding string.
     * @param $enc string unicode encoding name.
     * @return int unicode number.
     */
    public static function getUnicode($utf, $encoding = self::UTF8) {
        // UCS-4 is the same as Unicode number.
        $ucs = mb_convert_encoding($utf, self::UCS4, $encoding);
        $hex = bin2hex(mb_substr($ucs, 0, 1, self::UCS4));
        return hexdec($hex);
    }

    public static function at($str, $pos, $encoding = self::UTF8) {
        return mb_substr($str, $pos, 1, $encoding);
    }
    public static function first($str, $encoding = self::UTF8) {
        return mb_substr($str, 0, 1, $encoding);
    }
    public static function last($str, $encoding = self::UTF8) {
        return mb_substr($str, mb_strlen($str, $encoding) - 1, 1, $encoding);
    }
}
?>
