<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package core.beans.serializer
 */
/**
 * @file JSONBeanSerializer.php
 * @brief serialize bean to JSON
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: JSONBeanSerializer.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once "ficus/beans/serializer/BeanSerializer.php";

/**
 * @package core.beans.serializer
 * @class Soya_JSONBeanSerializer
 */
class Soya_JSONBeanSerializer implements Soya_BeanSerializer{
    /**
     * encoding
     */
    private $encoding = null;
     
    /**
     * constructor
     */
    public function __construct($encoding = ""){
        $this->setEncoding($encoding);
    }

    /**
     * serialize bean to RDFSchema
     * @param $bean Soya_Bean bean to serialize
     * @return string rdf string
     */
    public function serialize($bean){
        $array = $bean->serialize("Array");
        $string = json_encode($array);
        return $string;
    }

    /**
     * set encoding
     * @param $encoding string encoding of encoded json
     */
    public function setEncoding($encoding){
        $this->encoding = $encoding;
    }
}
?>
