package FFFF::Module::mail;

# --------------------------------------------------------------------
# FFFF::Module::mail 
# - ᡼
#
#
# --------------------------------------------------------------------
use strict;
use base qw(FFFF::Module::Base);

use POSIX qw(strftime);
use LocalCGI;

# --------------------------------------------------------------------
# HEADER_FIELD
# - եܿ
#
# --------------------------------------------------------------------
use constant HEADER_FIELD => [qw(
	From
	Subject
	To
	Cc
	Bcc
	Reply-To
	Return-Path
)];




# --------------------------------------------------------------------
# եβ
#
# CONFIG => {
#           DEBUG => 0,
#           SENDMAIL => '/usr/lib/sendmail -t',
#           TEMPLATE => 'example1_mail.txt',
#           TO => {
#              KEY  => 'q1',
#              DATA => {
#                     'cat' => 'tama@takefumi.com',
#                     'dog' => 'pochi@takefumi.com,
#              },
#           },
#           SUBJECT => {
#              KEY  => 'q1',
#              DATA => {
#                     'cat' => 'ǭΤʤ'
#                     'dog' => 'Τʤ',
#              },
#           },
#           :
#           :
# }
#
# --------------------------------------------------------------------
sub config {
	my $self = shift;
	my ($config) = @_;
	my %config;

	#
	# ǥ쥯ƥ֤β
	#
	for my $key (qw(sendmail template log debug)) {
		$config{uc $key} = $config->{$key}->[0]->[0];
	}

	#
	# DEBUG ե饰
	#
	$config{DEBUG} = ($config{DEBUG} =~ /^on$/i)? 1:0;


	#
	# HEADER_FIELD ǥ쥯ƥ֤β
	#
	for my $header_field (map{@$_} HEADER_FIELD) {

		#
		# Ƥʤм
		#
		my $cf = $config->{lc $header_field};
		next if (ref $cf ne "HASH");
	
		#
		# Ǥ2ȰʾʤեΥ顼
		#
		if (scalar(keys %{$cf}) >= 2) {
			die "$header_field is many setup.";
		}
		
		#
		# եβ
		#
		my ($key, $data) = each %$cf;
		my %data = %{(@$data)[0]};
		while (my ($k, $v) = each %data) {
			$data{$k} = join ", ", map{@$_} @$v;
		}
		$config{uc $header_field} = {
			KEY  => $key,
			DATA => \%data
		};
	}

	#
	# sendmail ꤵƤʤä
	#
	if ($config{SENDMAIL} eq "") {
		for my $sendmail (qw (/usr/lib/sendmail /usr/bin/sendmail)) {
			if (-f $sendmail) {
				$config{SENDMAIL} = "$sendmail -t";
			}
		}
		if ($config{SENDMAIL} eq "") {
			die "can't locate sendmail program.";
		}
	}

	$self->{CONFIG} = \%config;
}

# --------------------------------------------------------------------
# execute
# - ν
# - ᡼
#
# --------------------------------------------------------------------
sub execute {
	my $self     = shift;
	my (%form) = @_;

	my $config = $self->{CONFIG};

	#
	# ե뤫ǡ 
	#
	for my $header_field (map{@$_} HEADER_FIELD) {
		my $cf = $config->{uc $header_field};
		if (ref $cf eq "HASH") {
			$form{lc $header_field} = $cf->{DATA}->{$form{$cf->{KEY}}};
		}
	}


	#
	# ƥץ졼ȤŸ
	#
	my $mail = $self->get_mail_source(%form);


	#
	# ե¸
	#
	if ($config->{LOG} ne "") {
		my $datetime = strftime("%Y-%m-%d %H:%M:%S", localtime());
		my $log = $config->{LOG};
		open(LOG, ">>$log") or die "Can't open log : $log";
		print LOG "-- START $datetime -------------------------------\n";
		print LOG "$mail\n";
		print LOG "-- END $datetime ---------------------------------\n";
		close(LOG);
		
	}

	#
	# ᡼
	#
	if ($config->{DEBUG} == 0) {
		open(MAIL, "| $config->{SENDMAIL}");
		print MAIL toJIS($mail);
		close(MAIL);
	}
}

# --------------------------------------------------------------------
# ᡼ʸμ
#
# --------------------------------------------------------------------
sub get_mail_source {
	my $self   = shift;
	my (%form) = @_;

	return OutputTemplate($self->{CONFIG}->{TEMPLATE}, %form);
}

1;
=head CHANGES
0.0.3   2002/05/22
	- ⥸塼Υ֥Ȳ

0.0.2   2002/05/15
	- SendmailץͭˤʤäƤʤäХ

0.0.1   2002/05/09
	- original version
=cut
