package FFFF::Module::db;

# --------------------------------------------------------------------
# FFFF::Module::db 
#
#
# --------------------------------------------------------------------
use strict;
use DBI;

use base qw(FFFF::Module::Base);
use FFFF::Module::Filter;

# --------------------------------------------------------------------
# եβ
#
# CONFIG => {
#          DATA_SOURCE => 'dbi:Pg:dbname=4f'
#          USER_NAME   => 'user',
#          PASSWORD    => 'passwd',
#          INSERT => [
#                       {
#                          TABLE  => 'staff'
#                          COLUMN => {
#                                         id       => 'id',
#                                         kana     => 'kana',
#                                         email    => 'email',
#                                         name     => 'name'
#                                         mod_date => '{DB:now()}',
#                                    },
#                      },
#                   ],
#          DELETE_BREAK => 0,
# };
#
# --------------------------------------------------------------------
sub config {
	my $self = shift;
	my ($config) = @_;
	my %config;

	#
	# DB
	#
	$config{DATA_SOURCE} = $config->{datasource}->[0]->[0];
	$config{USER_NAME}   = $config->{username}->[0]->[0];
	$config{PASSWORD}    = $config->{password}->[0]->[0];


	#
	# ԥ(LF, CF)̵뤹뤫ɤ
	# ǥե: Off /  mod_csv Ȥϰ㤦Τ!
	#
	$config{DELETE_BREAK} = $config->{deletebreak}->[0]->[0];
	$config{DELETE_BREAK} = ($config{DELETE_BREAK} =~ /^Off$/i)? 1 : 0;


	#
	# INSERT TABLE
	#
	my @insert;
	while (my($table, $data) = each %{$config->{insert}}) {
		
		for my $col_ref (@$data) {

			#
			# VALUESBINDѿ
			#
			my (@col, @bind, @value);
			while (my ($col, $value) = each %$col_ref) {
				my $bind = $value->[0]->[0];

				if ($bind =~ /^{DB:(.+?)}$/) {
					push(@col, $col);
					push(@value, $1);
				}
				else {
					push(@col, $col);
					push(@value, '?');
					push(@bind, $bind );
				}
			}

			push(@insert, {
					SQL  => "INSERT INTO $table (" .  join(',', @col) . ") VALUES (" . join(',', @value) . ")",
					BIND => \@bind,
				}
			);
		}
	}
	$config{INSERT} = \@insert;

	$self->{CONFIG} = \%config;
}

# --------------------------------------------------------------------
# execute
# - ͤDB˥ǡǼ
#
# --------------------------------------------------------------------
sub execute {
	my $self   = shift;
	my (%form) = @_;;

	my $config = $self->{CONFIG};

    #
    # ե륿Υå
    #
    $self->set_filter();

	#
	# DB ³
	#
	my $dbh = DBI->connect(
		$config->{DATA_SOURCE},
		$config->{USER_NAME},
		$config->{PASSWORD},
		{ RaiseError => 1, AutoCommit => 0 }
	) or die $DBI::errstr;


	#
	# ǡ١˳Ǽ
	#
	for my $insert (map {@$_} $config->{INSERT}) {

		#
		# BINDѿΥå
		#
		my @bind = map {@$_} $insert->{BIND};
		for my $bind (@bind) {

			#
			# եफ
			#
			if ($bind =~ /^(\w+)$/) {
				$bind = $form{$1};
			}

			#
			# ե륿
			#
			else {
				$bind =~ s/{FORM:(.+?)}/$form{$1}/g;
				$bind =~ s/{(\w+):(.*?)}/$self->{FILTER}->execute($1, $2)/eg;
			}
		}

		#
		# ʸ
		#
		if ($config->{DELETE_BREAK} == 1) {
			for (@bind) { s/\n|\r//g; }
		}

		#
		# DB˳Ǽ
		#
		my $sth = $dbh->prepare($insert->{SQL});
		$sth->execute(@bind);
	}

	#
	# DB
	#
	$dbh->commit();
	$dbh->disconnect();
}

1;

=head CHANGES
0.0.3   2002/05/22
    - ⥸塼Υ֥Ȳ
    - ե륿Υ⥸塼벽

0.0.2   2002/05/16
    - strftime  %s(1970ΥեåáSolarisбƤʤΤ
      б

0.0.1   2002/05/09
    - original version
=cut
