package FFFF::Module::csv;

# --------------------------------------------------------------------
# FFFF::Module::csv 
# - CSVǡ¸
#
#
# --------------------------------------------------------------------
use strict;
use base qw(FFFF::Module::Base);

require "jcode.pl";

# --------------------------------------------------------------------
# եβ
#
# CONFIG => {
#           FILE => '/home/ta/{TIME:%Y_%m}.cvs',
#           SAVE => [
#                       '{TIME:%Y-%m-%d %H:%M:%S}',
#                       'id',
#                       'name',
#                       'kana',
#                       'email',
#                       '{FROM:zip1}-{FORM:zip2}',
#                       '{ENV:HTTP_USER_AGENT}',
#                       '{ENV:REMOTE_HOST}'
#                     ],
#           SEPARATE     => 'TAB'
#           CHAR_SET     => 'EUC-JP',
#           DELETE_BREAK => 1
# }
#
# --------------------------------------------------------------------
sub config {
	my $self = shift;
	my ($config) = @_;
	my %config;

	#
	# ¸
	#
	$config{SAVE} = [map{@$_} map{@$_} $config->{save}];
	
	#
	# إå
	#
	if (ref $config->{header} eq "ARRAY") {
		$config{HEADER} = [map{@$_} map{@$_} $config->{header}];
	}

	#
	# ¸ե
	#
	$config{FILE} = $config->{file}->[0]->[0];

	#
	# ¸
	#
	$config{SEPARATE} = ($config->{separate}->[0]->[0] =~ /^tab$/i)? "\t" : ",";


	#
	# ¸ʸ
	#
	$config{CHAR_SET} = $config->{charset}->[0]->[0];
	if ($config{CHAR_SET} =~ /^Shift_JIS$/i) {
		$config{CHAR_SET} = 'sjis';
	}
	elsif ($config{CHAR_SET} =~ /^EUC-JP$/i) {
		$config{CHAR_SET} = 'euc';
	}
	elsif ($config{CHAR_SET} =~ /^ISO-2022-JP$/i) {
		$config{CHAR_SET} = 'jis';
	}
	$config{CHAR_SET} ||= 'sjis';


	#
	# ԥ(LF, CF)̵뤹뤫ɤ
	# ǥե:On
	#
	$config{DELETE_BREAK} = $config->{deletebreak}->[0]->[0];
	$config{DELETE_BREAK} = ($config{DELETE_BREAK} =~ /^Off$/i)? 0 : 1;

	$self->{CONFIG} = \%config;
}

# --------------------------------------------------------------------
# execute
# - ͤƥեCSV¸
#
# --------------------------------------------------------------------
sub execute {
	my $self     = shift;
	my (%form) = @_;

	my $config = $self->{CONFIG};

	#
	# ե륿Υå
	#
	$self->set_filter();


	#
	# ե̾
	#
	my $file = $config->{FILE};
	$file =~ s/{FORM:(.+?)}/$form{$1}/g;
	$file =~ s/{(\w+):(.+)}/$self->{FILTER}->execute($1, $2)/eg;


	#
	# ¸ܤμ
	#
	my @save = $self->get_save_data(%form);


	#
	# ¸
	#
	open(CSV, ">>$file") or die "Can't Open file : $file";
	flock(CSV, 2) or die "Can't File Lock";
	seek(CSV, 0, 2);

	#
	# ե뤬 0 ХȤǥإåƤإå
	#
	if ((stat CSV)[7] == 0 and ref $config->{HEADER} eq "ARRAY") {

		my $header = join $config->{SEPARATE}, map {@$_} $config->{HEADER};
		$header = jcode::to($config->{CHAR_SET} , $header, "euc");
		print CSV "$header\n";
	}

	#
	# TABڤѴƥե¸
	#
	my $line;
	if ($config->{SEPARATE} eq "\t") {
		$line = join "\t", map {s/\t//g; $_} @save;
	}

	#
	# CSVѴƥե¸
	# http://www.din.or.jp/~ohzaki/perl.htm#CSVfromValues
	#
	else {
		$line = join ",", map {(s/"/""/g or /[\r\n,]/)? qq{"$_"} : $_} @save;
	}

	$line = jcode::to($config->{CHAR_SET}, $line, "euc");
	print CSV "$line\n";

	flock(CSV, 8);
	close(CSV);
}

# --------------------------------------------------------------------
# ¸ܤμ
#
# --------------------------------------------------------------------
sub get_save_data {
	my $self     = shift;
	my (%form) = @_;

	my $config = $self->{CONFIG};

	#
	# ¸ܤμ
	#
	my @save = map {@$_} $config->{SAVE};
	for my $save (@save) {

		#
		# եफ
		#
		if ($save =~ /^(\w+)$/) {
			$save = $form{$1};
		}

		#
		# ե륿
		#
		else {
			$save =~ s/{FORM:(.+?)}/$form{$1}/g;
			$save =~ s/{(\w+):(.*?)}/$self->{FILTER}->execute($1, $2)/eg;
		}
	}

	#
	# ʸ
	#
	if ($config->{DELETE_BREAK} == 1) {
		for (@save) { s/\n|\r//g; }
	}

	return @save;
}

1;
__END__
=head CHANGES
0.0.4   2002/05/21
	- ⥸塼Υ֥Ȳ
	- ե륿Υ⥸塼벽

0.0.3   2002/05/15
	- ʸɤλб
"CharSet  EUC-JP" ͤ˻ꤷޤ
	- strftime  %s(1970ΥեåáSolarisбƤʤΤ
	  б

0.0.2   2002/05/14
	- Header ꤷƤʤȥ顼ˤʤХ
	- TABڤб
	  "Separate  Tab" ͤ˻ꤷޤ

0.0.1   2002/05/09
	- original version
=cut

