package FFFF::Module::Filter;

# --------------------------------------------------------------------
# FFFF::Module::Filter
# - ե륿
#
#
# --------------------------------------------------------------------
use strict;
use POSIX qw(strftime);
$FFFF::Module::Filter::TIME = time();

# -------------------------------------------------------------------------
# new
#
# -------------------------------------------------------------------------
sub new {
    my $class = shift;

    my $self = bless {}, $class;

    $self->prepare(
		STR  => \&filter_STR,
		TIME => \&filter_TIME,
		ENV  => \&filter_ENV,
    );

    return $self;
}

# -------------------------------------------------------------------------
# ե륿ѥν
#
# -------------------------------------------------------------------------
sub prepare {
    my $self = shift;
    my (%func) = @_;

    while (my ($key, $value) = each %func) {
         $self->{FILTER}->{$key} = $value;
    }

    return $self;
}

# --------------------------------------------------------------------
# ե륿
#
# --------------------------------------------------------------------
sub execute {
    my $self     = shift;
    my ($filter_name, $value) = @_;

    my $func = $self->{FILTER}->{$filter_name};

    return &$func($value);
}

sub filter_ENV {
    my ($key) = @_;

    return $ENV{$key};
}

sub filter_TIME {
    my ($format) = @_;

    #
    # Solaris  %s бƤʤк
    #
    $format =~ s/\%s/$FFFF::Module::Filter::TIME/g;

    return strftime($format, localtime($FFFF::Module::Filter::TIME));
}

sub filter_STR {
    my ($value) = @_;

    return  $value;
}

1;
__END__
=head CHANGES
0.0.1   2002/05/21
    - original version
=cut
