package Base::Session::File;
# -------------------------------------------------------------------------
# Base::Session::File
#
# - Apache::Session::File 
#
#   ץ
#   * SESSION_OPTION
#     Apache::Session::File Ϥѥ᡼
#
#   * DIGEST_KEY
#     åϥåɻߤΤ̩
# 
#   * EXPIRE
#     åͭ 0 ξ̵
#
#
# -------------------------------------------------------------------------
use strict;
use Carp;

use Apache::Session::File;

use vars qw(@ISA);
@ISA = qw(Base::Session);
use Base::Session;


# -------------------------------------------------------------------------
# åǡɤ߹ߡ
#
# -------------------------------------------------------------------------
sub load {
    my $self = shift;
    my ($sid)  = @_;

    $self->{session} = tie my %session, 'Apache::Session::File', $sid, $self->{SESSION_OPTION};

    return $self;
}


# -------------------------------------------------------------------------
# åID뤫ɤΥå
#
# -------------------------------------------------------------------------
sub is_session {
    my $self = shift;
	my ($sid) = @_;

	if ($sid and -e $self->{SESSION_OPTION}->{Directory} . "/$sid") {
		return 1;
	}
	else {
		return undef;
	}
}


# -------------------------------------------------------------------------
# åեκ
#
# -------------------------------------------------------------------------
sub expire {
	my $self = shift;

	my $session_id = $self->id;

	unlink $self->{SESSION_OPTION}->{Directory} . "/$session_id";
	unlink $self->{SESSION_OPTION}->{LockDirectory} . "/Apache-Session-${session_id}.lock";
}


# -------------------------------------------------------------------------
# ॢȤƤ륻åեʥ֥Ⱥ
#
# -------------------------------------------------------------------------
sub cleanup {
    my $self = shift;

	#
	# ͭ¤ꤵƤ뤫
	#
	if ($self->{EXPIRE} <= 0 or $self->{EXPIRE} =~ /\D/) {
		croak "Since EXPIRE is not set up, it cannot perform.";
	}
	my $expire = time() - $self->{EXPIRE};

	for my $dir (values %{$self->{SESSION_OPTION}}) {

		opendir(SESSION, $dir) or croak "Can't open directory: [$dir]";

		#
		# оݤΥե
		#
		my @rm_file = 
			grep (((stat($_))[9] <= $expire),                     # $expire Ťʪ
			map  {"$dir/$_"}                                      # ǥ쥯ȥ̾ղ
			grep /(:?Apache\-Session\-)?[0-9a-fA-F](:?\.lock)?/,  # Apaceh::SecctionΥե뤫?
			readdir(SESSION));

		closedir(SESSION);
		return unlink(@rm_file);
	}

}

1;
