package jp.ac.osaka_u.ist.sel.similarity.tokenizer.parser;

import java.util.List;
import java.util.LinkedList;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;

%%

%public
%class JavaScanner
%function scanCode
%type List
%eofclose

%unicode
%line
%column

%init{
  this._tokenList = new LinkedList();
  this._literalLN = Pattern.compile("\\\\\n");
  this._errorCount = 0;
%init}

%{
  private final Logger _log = Logger.getLogger("JavaScanner");
  private List _tokenList;
  private Pattern _literalLN;
  private int _errorCount;
  
  public int getErrorCount() {
	  return this._errorCount;
  }
%}

D  =		[0-9]
L  =		[a-zA-Z_$]
H  =		[a-fA-F0-9]
E  =		[Ee][+-]?{D}+
FType =		(f|F|l|L)
IType =		(u|U|l|L)*

%state DEFINE, IFZERO

%%

<YYINITIAL> {
/* Comment */

"/*"~"*/"					{ /* Ignore */ }
[ \t\v\n\r\f]				{ /* Ignore */ }

/* Reserved Words */

"byte"						{ _tokenList.add("byte"); }
"char"						{ _tokenList.add("char"); }
"short"						{ _tokenList.add("short"); }
"int"						{ _tokenList.add("int"); }
"long"						{ _tokenList.add("long"); }
"float"						{ _tokenList.add("float"); }
"double"						{ _tokenList.add("double"); }
"boolean"						{ _tokenList.add("boolean"); }
"true"						{ _tokenList.add("true"); }
"false"						{ _tokenList.add("false"); }
"void"						{ _tokenList.add("void"); }
"if"						{ _tokenList.add("if"); }
"else"						{ _tokenList.add("else"); }
"switch"						{ _tokenList.add("switch"); }
"case"						{ _tokenList.add("case"); }
"default"						{ _tokenList.add("default"); }
"for"						{ _tokenList.add("for"); }
"while"						{ _tokenList.add("while"); }
"do"						{ _tokenList.add("do"); }
"continue"						{ _tokenList.add("continue"); }
"break"						{ _tokenList.add("break"); }
"return"						{ _tokenList.add("return"); }
"package"						{ _tokenList.add("package"); }
"import"						{ _tokenList.add("import"); }
"class"						{ _tokenList.add("class"); }
"interface"						{ _tokenList.add("interface"); }
"extends"						{ _tokenList.add("extends"); }
"implements"						{ _tokenList.add("implements"); }
"this"						{ _tokenList.add("this"); }
"super"						{ _tokenList.add("super"); }
"new"						{ _tokenList.add("new"); }
"null"						{ _tokenList.add("null"); }
"instanceof"						{ _tokenList.add("instanceof"); }
"public"						{ _tokenList.add("public"); }
"protected"						{ _tokenList.add("protected"); }
"private"						{ _tokenList.add("private"); }
"final"						{ _tokenList.add("final"); }
"static"						{ _tokenList.add("static"); }
"abstract"						{ _tokenList.add("abstract"); }
"native"						{ _tokenList.add("native"); }
"synchronized"						{ _tokenList.add("synchronized"); }
"volatile"						{ _tokenList.add("volatile"); }
"transient"						{ _tokenList.add("transient"); }
"try"						{ _tokenList.add("try"); }
"catch"						{ _tokenList.add("catch"); }
"finally"						{ _tokenList.add("finally"); }
"throw"						{ _tokenList.add("throw"); }
"throws"						{ _tokenList.add("throws"); }
"assert"						{ _tokenList.add("assert"); }
"enum"						{ _tokenList.add("enum"); }
"const"						{ _tokenList.add("const"); }
"goto"						{ _tokenList.add("goto"); }
"strictfp"						{ _tokenList.add("strictfp"); }
"@"							{ _tokenList.add("@"); }

{L}({L}|{D})*				{ _tokenList.add(yytext()); } 
                               
/* String Literal */
\"(\\[0-9]+|\\\n|\\[^\n]|[^\\\"])*\"	{ String text = yytext(); text = _literalLN.matcher(text).replaceAll(""); _tokenList.add( text ); }

/* Character Literal */
\'(\\u[0-9a-fA-F]+|\\x[0-9a-fA-F]+|\\[0-9]+|\\[^\n]|[^\\\'])+\'	{ _tokenList.add( yytext() ); }

0[xX]{H}+{IType}?			{ _tokenList.add(yytext()); }
0{D}+{IType}?				{ _tokenList.add(yytext()); }
{D}+{IType}?				{ _tokenList.add(yytext()); }

{D}+{E}{FType}?				{ _tokenList.add(yytext()); }
{D}*"."{D}+({E})?{FType}?	{ _tokenList.add(yytext()); }
{D}+"."{D}*({E})?{FType}?	{ _tokenList.add(yytext()); }

"("							{ _tokenList.add("("); }
")"							{ _tokenList.add(")"); }

"["							{ _tokenList.add("["); }
"]"							{ _tokenList.add("]"); }

"{"							{ _tokenList.add("{"); }
"}"							{ _tokenList.add("}"); }

"!"							{ _tokenList.add("!"); }
"!="						{ _tokenList.add("!="); }

"%"							{ _tokenList.add("%"); }
"%="						{ _tokenList.add("%="); }

"^"							{ _tokenList.add("^"); }
"^="						{ _tokenList.add("^="); }

"&"							{ _tokenList.add("&"); }
"&="						{ _tokenList.add("&="); }
"&&"						{ _tokenList.add("&&"); }

"|"							{ _tokenList.add("|"); }
"|="						{ _tokenList.add("|="); }
"||"						{ _tokenList.add("||"); }

"*"							{ _tokenList.add("*"); }
"*="						{ _tokenList.add("*="); }

"/"							{ _tokenList.add("/"); }
"/="						{ _tokenList.add("/="); }

"+"							{ _tokenList.add("+"); }
"+="						{ _tokenList.add("+="); }
"++"						{ _tokenList.add("++"); }

"-"							{ _tokenList.add("-"); }
"-="						{ _tokenList.add("-="); }
"--"						{ _tokenList.add("--"); }

"<"							{ _tokenList.add("<"); }
"<="						{ _tokenList.add("<="); }
"<<"						{ _tokenList.add("<<"); }
"<<="						{ _tokenList.add("<<="); }

">"							{ _tokenList.add(">"); }
">="						{ _tokenList.add(">="); }
">>"						{ _tokenList.add(">>"); }
">>="						{ _tokenList.add(">>="); }

"->"						{ _tokenList.add("->"); }
"..."						{ _tokenList.add("..."); }
"="							{ _tokenList.add("="); }
"=="						{ _tokenList.add("=="); }

","							{ _tokenList.add(","); }
"."							{ _tokenList.add("."); }
";"							{ _tokenList.add(";"); }
":"							{ _tokenList.add(":"); }
"?"							{ _tokenList.add("?"); }
"#"							{ _tokenList.add("#"); }
"##"						{ _tokenList.add("##"); }
"~"							{ _tokenList.add("~"); }
}

.							{ String illegalWord = yytext();
                              String err = "Illegal character '" + illegalWord + "' at line " + yyline + ", column " + yycolumn;
                              err += " after ";
                              for (int i=3;i>0;i--)
                              {
                                int index = _tokenList.size() - i;
                                if (index < 0) {
                                  continue;
                                }
                                if (i == 3) {
                                  err += "'" + _tokenList.get(index) + "'";
                                } else {
                                  err += ", '" + _tokenList.get(index) + "'";
                                }
                              }
                              _log.info(err);
                              _tokenList.add(illegalWord);
                              this._errorCount++; }
                                                              
<<EOF>>                 	{ return _tokenList;}

