package jp.ac.osaka_u.ist.sel.similarity.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;


import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * XML parser for input directory list.
 * 
 * @author ysk-ssk
 *
 */
public class DirListXmlParser {
    /**
     * is an utility class.
     */
    private DirListXmlParser() {
    }
    
	public static List<String> parseXml(String xmlPath) throws ParserConfigurationException, SAXException, IOException {
        List<String> dirPathList = new ArrayList<String>();
        
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(xmlPath);
        
        Element rootElement = document.getDocumentElement();
        if (!rootElement.getTagName().equals(RegisterTarget._elementName)) {
            throw new RuntimeException("Unknown tag: " + rootElement.getTagName());
        }
        NodeList domainElements = rootElement.getElementsByTagName(RegisterTarget.Domain._elementName);
        for (int i = 0; i < domainElements.getLength(); i++) {
            Element domainElement = (Element) domainElements.item(i);
            String basepath;
            if (domainElement.hasAttribute(RegisterTarget.Domain._basepath)) {
                basepath = domainElement.getAttribute(RegisterTarget.Domain._basepath);
            } else {
                throw new RuntimeException("basepath attribute not found in domain tag.");
            }
            dirPathList.add(basepath);
        }
        
		return dirPathList;
	}

	public static void outputXml(List<String> dirPathList, String xmlPath) throws IOException, XMLStreamException {
			XMLOutputFactory factory = XMLOutputFactory.newInstance();
			FileWriter fileWriter = null;
			XMLStreamWriter xmlWriter = null;
			
			File xmlFile = new File(xmlPath);
            if (xmlFile.exists() && !xmlFile.canWrite()) {
                throw new RuntimeException("Can not write: " + xmlPath);
            }
			try {
				fileWriter = new FileWriter(xmlPath);
				xmlWriter = factory.createXMLStreamWriter(fileWriter);
	
				xmlWriter.writeStartDocument("UTF-8","1.0");
				xmlWriter.writeStartElement(RegisterTarget._elementName);
				for (String dirPath : dirPathList) {
					xmlWriter.writeEmptyElement(RegisterTarget.Domain._elementName);
					xmlWriter.writeAttribute(RegisterTarget.Domain._basepath, dirPath);
				}
				xmlWriter.writeEndElement();
				xmlWriter.writeEndDocument();
			} finally {
				try {
					if (xmlWriter != null) {
						xmlWriter.close();
					}
					if (fileWriter != null) {
						fileWriter.close();
					}
				} catch (XMLStreamException e) {
					e.printStackTrace();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
	
		}

}

