package jp.ac.osaka_u.ist.sel.similarity.register.database;

import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;

import jp.ac.osaka_u.ist.sel.similarity.database.DatabaseCreationDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

/**
 * This class has following class instances:
 * 
 * * TransactionManager
 * * AppDAO
 * * FileDAO
 * 
 * When you create an instance of this class, the instance initializes all DAO classes which it has.
 * If you create this class, you need to close after all executions.
 * 
 * @author ysk-ssk
 *
 */
public class FileRegisterDAOManager {
	private TransactionManager _transactionManager;
	private InsertionDomainDAO _domainDAO;
	private InsertionFileDAO _fileDAO;
	
	public FileRegisterDAOManager(String dbPath) throws SQLException {
		_transactionManager = new TransactionManager(dbPath);
        DatabaseCreationDAO creationDAO = new DatabaseCreationDAO(_transactionManager);
        // create domain info table
        try {
            creationDAO.createDomainInfo();
        } catch (SQLSyntaxErrorException e) {
        } catch (SQLException e) {
        }
        _domainDAO = new InsertionDomainDAO(_transactionManager);
        // create file info table
        try {
            creationDAO.createFileInfo();
        } catch (SQLSyntaxErrorException e) {
        } catch (SQLException e) {
        }
		_fileDAO = new InsertionFileDAO(_transactionManager);
	}
	
	public InsertionDomainDAO getDomainDAO() {
		return _domainDAO;
	}

	public InsertionFileDAO getFileDAO() {
		return _fileDAO;
	}
	
	public void close() throws SQLException {
		_transactionManager.close();
	}
}
