package jp.ac.osaka_u.ist.sel.similarity.hash.tokenizer;

import java.io.Reader;

import jp.ac.osaka_u.ist.sel.similarity.hash.database.InsertionTokenInfoDAO;
import jp.ac.osaka_u.ist.sel.similarity.hash.parser.JavaTokenStream;
import jp.ac.osaka_u.ist.sel.similarity.hash.parser.TokenStream;

/**
 * Return java parser class for the super class, TokenInfoRegister. 
 * 
 * @author ysk-ssk
 *
 */
public class JavaTokenInfoRegister extends TokenInfoRegister {

    public JavaTokenInfoRegister(InsertionTokenInfoDAO tokenDAO) {
        super(tokenDAO);
    }

    @Override
    protected TokenStream getTokenStream(Reader reader) {
        return new JavaTokenStream(reader);
    }

}
