package jp.ac.osaka_u.ist.sel.similarity.tokenizer.parser;

import java.util.List;
import java.util.LinkedList;
import java.util.regex.Pattern;

import org.apache.log4j.Logger;

%%

%public
%class CScanner
%function scanCode
%type List
%eofclose

%unicode
%line
%column

%init{
  this._tokenList = new LinkedList();
  this._ifZeroCount = 0;
  this._literalLN = Pattern.compile("\\\\\n");
  this._errorCount = 0;
%init}

%{
  private final Logger _log = Logger.getLogger("CScanner");
  private List _tokenList;
  private int _ifZeroCount;
  private Pattern _literalLN;
  private int _errorCount;
  
  public int getErrorCount() {
	  return this._errorCount;
  }
%}

D  =		[0-9]
L  =		[a-zA-Z_$]
H  =		[a-fA-F0-9]
E  =		[Ee][+-]?{D}+
FType =		(f|F|l|L)
IType =		(u|U|l|L)*

%state DEFINE, IFZERO

%%

<YYINITIAL> {
/* Comment */

"/*"~"*/"					{ /* Ignore */ }
\n#if[ \t\v\f]+0			{ _ifZeroCount++; yybegin(IFZERO); }
[ \t\v\n\r\f]				{ /* Ignore */ }

/* Reserved Words */

"auto"						{ _tokenList.add("auto"); }
"break"						{ _tokenList.add("break"); }
"case"						{ _tokenList.add("case"); }
"char"						{ _tokenList.add("char"); }
"const"						{ _tokenList.add("const"); }
"continue"					{ _tokenList.add("continue"); }
"default"					{ _tokenList.add("default"); }
"do"						{ _tokenList.add("do"); }
"double"					{ _tokenList.add("double"); }
"else"						{ _tokenList.add("else"); }
"enum"						{ _tokenList.add("enum"); }
"extern"					{ _tokenList.add("extern"); }
"float"						{ _tokenList.add("float"); }
"for"						{ _tokenList.add("for"); }
"goto"						{ _tokenList.add("goto"); }
"if"						{ _tokenList.add("if"); }
"int"						{ _tokenList.add("int"); }
"long"						{ _tokenList.add("long"); }
"register"					{ _tokenList.add("register"); }
"return"					{ _tokenList.add("return"); }
"short"						{ _tokenList.add("short"); }
"signed"					{ _tokenList.add("signed"); }
"sizeof"					{ _tokenList.add("sizeof"); }
"static"					{ _tokenList.add("static"); }
"struct"					{ _tokenList.add("struct"); }
"switch"					{ _tokenList.add("switch"); }
"typedef"					{ _tokenList.add("typedef"); }
"union"						{ _tokenList.add("union"); }
"unsigned"					{ _tokenList.add("unsigned"); }
"void"						{ _tokenList.add("void"); }
"volatile"					{ _tokenList.add("volatile"); }
"while"						{ _tokenList.add("while"); }

{L}({L}|{D})*				{ _tokenList.add(yytext()); } 
                               
/* String Literal */
\"(\\[0-9]+|\\\n|\\[^\n]|[^\\\"])*\"	{ String text = yytext(); text = _literalLN.matcher(text).replaceAll(""); _tokenList.add( text ); }

/* Character Literal */
\'(\\x[0-9a-fA-F]+|\\[0-9]+|\\[^\n]|[^\\\'])+\'	{ _tokenList.add( yytext() ); }

/* define macro */
"\n#define"                 { _tokenList.add("#"); _tokenList.add("define"); yybegin(DEFINE); }

0[xX]{H}+{IType}?			{ _tokenList.add(yytext()); }
0{D}+{IType}?				{ _tokenList.add(yytext()); }
{D}+{IType}?				{ _tokenList.add(yytext()); }

{D}+{E}{FType}?				{ _tokenList.add(yytext()); }
{D}*"."{D}+({E})?{FType}?	{ _tokenList.add(yytext()); }
{D}+"."{D}*({E})?{FType}?	{ _tokenList.add(yytext()); }

"("							{ _tokenList.add("("); }
")"							{ _tokenList.add(")"); }

"["							{ _tokenList.add("["); }
"]"							{ _tokenList.add("]"); }

"{"							{ _tokenList.add("{"); }
"}"							{ _tokenList.add("}"); }

"!"							{ _tokenList.add("!"); }
"!="						{ _tokenList.add("!="); }

"%"							{ _tokenList.add("%"); }
"%="						{ _tokenList.add("%="); }

"^"							{ _tokenList.add("^"); }
"^="						{ _tokenList.add("^="); }

"&"							{ _tokenList.add("&"); }
"&="						{ _tokenList.add("&="); }
"&&"						{ _tokenList.add("&&"); }

"|"							{ _tokenList.add("|"); }
"|="						{ _tokenList.add("|="); }
"||"						{ _tokenList.add("||"); }

"*"							{ _tokenList.add("*"); }
"*="						{ _tokenList.add("*="); }

"/"							{ _tokenList.add("/"); }
"/="						{ _tokenList.add("/="); }

"+"							{ _tokenList.add("+"); }
"+="						{ _tokenList.add("+="); }
"++"						{ _tokenList.add("++"); }

"-"							{ _tokenList.add("-"); }
"-="						{ _tokenList.add("-="); }
"--"						{ _tokenList.add("--"); }

"<"							{ _tokenList.add("<"); }
"<="						{ _tokenList.add("<="); }
"<<"						{ _tokenList.add("<<"); }
"<<="						{ _tokenList.add("<<="); }

">"							{ _tokenList.add(">"); }
">="						{ _tokenList.add(">="); }
">>"						{ _tokenList.add(">>"); }
">>="						{ _tokenList.add(">>="); }

"->"						{ _tokenList.add("->"); }
"..."						{ _tokenList.add("..."); }
"="							{ _tokenList.add("="); }
"=="						{ _tokenList.add("=="); }

","							{ _tokenList.add(","); }
"."							{ _tokenList.add("."); }
";"							{ _tokenList.add(";"); }
":"							{ _tokenList.add(":"); }
"?"							{ _tokenList.add("?"); }
"#"							{ _tokenList.add("#"); }
"##"						{ _tokenList.add("##"); }
"~"							{ _tokenList.add("~"); }

"\\"						{ _tokenList.add("\\"); }
}

<DEFINE> {
/* Comment */

"/*"~"*/"					{ /* Ignore */ }

"\\\n"						{ /* Ignore */ }
[ \t\v\r\f]					{ /* Ignore */ }

\n                          { yybegin(YYINITIAL); }

/* Reserved Words */

"auto"						{ _tokenList.add("auto"); }
"break"						{ _tokenList.add("break"); }
"case"						{ _tokenList.add("case"); }
"char"						{ _tokenList.add("char"); }
"const"						{ _tokenList.add("const"); }
"continue"					{ _tokenList.add("continue"); }
"default"					{ _tokenList.add("default"); }
"do"						{ _tokenList.add("do"); }
"double"					{ _tokenList.add("double"); }
"else"						{ _tokenList.add("else"); }
"enum"						{ _tokenList.add("enum"); }
"extern"					{ _tokenList.add("extern"); }
"float"						{ _tokenList.add("float"); }
"for"						{ _tokenList.add("for"); }
"goto"						{ _tokenList.add("goto"); }
"if"						{ _tokenList.add("if"); }
"int"						{ _tokenList.add("int"); }
"long"						{ _tokenList.add("long"); }
"register"					{ _tokenList.add("register"); }
"return"					{ _tokenList.add("return"); }
"short"						{ _tokenList.add("short"); }
"signed"					{ _tokenList.add("signed"); }
"sizeof"					{ _tokenList.add("sizeof"); }
"static"					{ _tokenList.add("static"); }
"struct"					{ _tokenList.add("struct"); }
"switch"					{ _tokenList.add("switch"); }
"typedef"					{ _tokenList.add("typedef"); }
"union"						{ _tokenList.add("union"); }
"unsigned"					{ _tokenList.add("unsigned"); }
"void"						{ _tokenList.add("void"); }
"volatile"					{ _tokenList.add("volatile"); }
"while"						{ _tokenList.add("while"); }

{L}({L}|{D})*				{ _tokenList.add(yytext()); } 

/* String Literal */
\"(\\[0-9]+|\\\n|\\[^\n]|[^\\\"])*\"	{ String text = yytext(); text = _literalLN.matcher(text).replaceAll(""); _tokenList.add( text ); }

/* Character Literal */
\'(\\x[0-9a-fA-F]+|\\[0-9]+|\\[^\n]|[^\\\'])+\'	{ _tokenList.add( yytext() ); }
                               
0[xX]{H}+{IType}?			{ _tokenList.add(yytext()); }
0{D}+{IType}?				{ _tokenList.add(yytext()); }
{D}+{IType}?				{ _tokenList.add(yytext()); }

{D}+{E}{FType}?				{ _tokenList.add(yytext()); }
{D}*"."{D}+({E})?{FType}?	{ _tokenList.add(yytext()); }
{D}+"."{D}*({E})?{FType}?	{ _tokenList.add(yytext()); }

"("							{ _tokenList.add("("); }
")"							{ _tokenList.add(")"); }

"["							{ _tokenList.add("["); }
"]"							{ _tokenList.add("]"); }

"{"							{ _tokenList.add("{"); }
"}"							{ _tokenList.add("}"); }

"!"							{ _tokenList.add("!"); }
"!="						{ _tokenList.add("!="); }

"%"							{ _tokenList.add("%"); }
"%="						{ _tokenList.add("%="); }

"^"							{ _tokenList.add("^"); }
"^="						{ _tokenList.add("^="); }

"&"							{ _tokenList.add("&"); }
"&="						{ _tokenList.add("&="); }
"&&"						{ _tokenList.add("&&"); }

"|"							{ _tokenList.add("|"); }
"|="						{ _tokenList.add("|="); }
"||"						{ _tokenList.add("||"); }

"*"							{ _tokenList.add("*"); }
"*="						{ _tokenList.add("*="); }

"/"							{ _tokenList.add("/"); }
"/="						{ _tokenList.add("/="); }

"+"							{ _tokenList.add("+"); }
"+="						{ _tokenList.add("+="); }
"++"						{ _tokenList.add("++"); }

"-"							{ _tokenList.add("-"); }
"-="						{ _tokenList.add("-="); }
"--"						{ _tokenList.add("--"); }

"<"							{ _tokenList.add("<"); }
"<="						{ _tokenList.add("<="); }
"<<"						{ _tokenList.add("<<"); }
"<<="						{ _tokenList.add("<<="); }

">"							{ _tokenList.add(">"); }
">="						{ _tokenList.add(">="); }
">>"						{ _tokenList.add(">>"); }
">>="						{ _tokenList.add(">>="); }

"->"						{ _tokenList.add("->"); }
"..."						{ _tokenList.add("..."); }
"="							{ _tokenList.add("="); }
"=="						{ _tokenList.add("=="); }

","							{ _tokenList.add(","); }
"."							{ _tokenList.add("."); }
";"							{ _tokenList.add(";"); }
":"							{ _tokenList.add(":"); }
"?"							{ _tokenList.add("?"); }
"#"							{ _tokenList.add("#"); }
"##"						{ _tokenList.add("##"); }
"~"							{ _tokenList.add("~"); }

"\\"						{ _tokenList.add("\\"); }
}

<IFZERO> {
\n#if([^ \t\v\n\r\f])*		{ _ifZeroCount++; }
\n#endif					{ _ifZeroCount--; if (_ifZeroCount <= 0) { _ifZeroCount = 0; yybegin(YYINITIAL); } }
.+							{ /* Ignore */ }
\n							{ /* Ignore */ }
}

.							{ String illegalWord = yytext();
                              String err = "Illegal character '" + illegalWord + "' at line " + yyline + ", column " + yycolumn;
                              err += " after ";
                              for (int i=3;i>0;i--)
                              {
                                int index = _tokenList.size() - i;
                                if (index < 0) {
                                  continue;
                                }
                                if (i == 3) {
                                  err += "'" + _tokenList.get(index) + "'";
                                } else {
                                  err += ", '" + _tokenList.get(index) + "'";
                                }
                              }
                              _log.info(err);
                              _tokenList.add(illegalWord);
                              this._errorCount++; }
                                                              
<<EOF>>                 	{ return _tokenList;}

