package jp.ac.osaka_u.ist.sel.similarity.hash.database;

import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;

import jp.ac.osaka_u.ist.sel.similarity.commons.Settings;
import jp.ac.osaka_u.ist.sel.similarity.database.DatabaseCreationDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

/**
 * This class has following class instances:
 * 
 * * TransactionManager
 * * DAO class for FileInfo table
 * * DAO class for HashInfo table
 * * DAO class for TokenInfo table (option)
 * 
 * When you create an instance of this class, the instance initializes all DAO classes.
 * And you need to close after all executions.
 * 
 * @author ysk-ssk
 *
 */
public class HashRegisterDAOManager {
	private TransactionManager _transactionManager;
	private SelectionFileDAO _fileDAO;
    private InsertionHashInfoDAO _hashDAO;
	private InsertionTokenInfoDAO _tokenDAO;
	
	public HashRegisterDAOManager(String dbPath) throws SQLException {
		_transactionManager = new TransactionManager(dbPath);
		_fileDAO = new SelectionFileDAO(_transactionManager);
        DatabaseCreationDAO creationDAO = new DatabaseCreationDAO(_transactionManager);
        // make token info table if dump mode.
        if (Settings.getInstance().getWorkingPath() != null) {
            try {
                creationDAO.createTokenInfo();
            } catch (SQLSyntaxErrorException e) {
            } catch (SQLException e) {
            }
            _tokenDAO = new InsertionTokenInfoDAO(_transactionManager);
        }
        // make hash info table
        try {
            creationDAO.createHashInfo();
        } catch (SQLSyntaxErrorException e) {
        } catch (SQLException e) {
        }
        _hashDAO = new InsertionHashInfoDAO(_transactionManager);
	}

	public SelectionFileDAO getFileDAO() {
		return _fileDAO;
	}
	
    public InsertionHashInfoDAO getHashDAO() {
        return _hashDAO;
    }
    
	public InsertionTokenInfoDAO getTokenDAO() {
		return _tokenDAO;
	}
	
	public void close() throws SQLException {
		_transactionManager.close();
	}
}
