package jp.ac.osaka_u.ist.sel.similarity.hash;

import java.sql.SQLException;

import jp.ac.osaka_u.ist.sel.similarity.commons.ArgumentParser;
import jp.ac.osaka_u.ist.sel.similarity.commons.Settings;
import jp.ac.osaka_u.ist.sel.similarity.hash.database.HashRegisterDAOManager;
import jp.ac.osaka_u.ist.sel.similarity.register.FileRegisterMain;

public class HashRegisterMain {
    /**
     * @param args
     */
    public static void main(String[] args) {
        if (!ArgumentParser.parseArgument(args)) {
            return;
        }

        Settings settings = Settings.getInstance();
        
        FileRegisterMain.main(args);
        
        HashRegisterDAOManager daoManager = null;
        try {
            daoManager = new HashRegisterDAOManager(settings.getDatabasePath());
            HashInfoRegister register = new HashInfoRegister(daoManager);
            register.clusterFile();
        } catch (Throwable e) {
            e.printStackTrace();
        } finally {
            try {
                if (daoManager != null) {
                    daoManager.close();
                }
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

}
