package jp.ac.osaka_u.ist.sel.similarity.fileclone.register;

import java.sql.SQLException;

import jp.ac.osaka_u.ist.sel.similarity.commons.ArgumentParser;
import jp.ac.osaka_u.ist.sel.similarity.commons.Settings;
import jp.ac.osaka_u.ist.sel.similarity.fileclone.database.CloneRegisterDAOManager;
import jp.ac.osaka_u.ist.sel.similarity.hash.HashRegisterMain;
import jp.ac.osaka_u.ist.sel.similarity.register.FileRegisterMain;

import org.apache.log4j.BasicConfigurator;

public class CloneRegisterMain {

    public static void main(String[] args) throws SQLException {
        if (!ArgumentParser.parseArgument(args)) {
            return;
        }

        Settings settings = Settings.getInstance();

        HashRegisterMain.main(args);
        
        CloneRegisterDAOManager selectionDAOManager = null;
        try {
            selectionDAOManager = new CloneRegisterDAOManager(settings.getDatabasePath());
            CloneInfoRegister register = new CloneInfoRegister(selectionDAOManager);
            register.execute();
        } catch (Throwable e) {
            e.printStackTrace();
        } finally {
            try {
                if (selectionDAOManager != null) {
                    selectionDAOManager.close();
                }
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

}
