package jp.ac.osaka_u.ist.sel.similarity.fileclone.database;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.ac.osaka_u.ist.sel.similarity.database.AbstractDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

/**
 * DAO class for CloneInfo table.
 * Insert clone data into CloneInfo table.
 * 
 * @author ysk-ssk
 *
 */
public class InsertionCloneInfoDAO extends AbstractDAO {
	
	public InsertionCloneInfoDAO(TransactionManager transactionManager)
			throws SQLException {
		super(transactionManager);
	}
	
	public boolean insertData(int id, int groupId) throws SQLException {
		PreparedStatement pstmt = null;
		// create sql
		String sql = "insert into " + TableType.CLONE_INFO + " values (?,?)";
		// prepare the statement
		pstmt = prepareStatement(sql);
		pstmt.setInt(1, id);
		pstmt.setInt(2, groupId);
		// execute query
		if (executeUpdate(pstmt) == 1) {
			return true;
		}
		return false;
	}

}
