package jp.ac.osaka_u.ist.sel.similarity.fileclone.database;

import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;

import jp.ac.osaka_u.ist.sel.similarity.database.DatabaseCreationDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

/**
 * This class has following class instances:
 * 
 * * TransactionManager
 * * DAO class for HashInfo table
 * * DAO class for CloneInfo table
 * 
 * When you create an instance of this class, the instance initializes all DAO classes.
 * And you need to close after all executions.
 * 
 * @author ysk-ssk
 *
 */
public class CloneRegisterDAOManager {
	private TransactionManager _transactionManager;
	private SelectionHashDAO _hashDAO;
	private InsertionCloneInfoDAO _filecloneDAO;
	
	public CloneRegisterDAOManager(String dbPath) throws SQLException {
		_transactionManager = new TransactionManager(dbPath);
		_hashDAO = new SelectionHashDAO(_transactionManager);
        DatabaseCreationDAO creationDAO = new DatabaseCreationDAO(_transactionManager);
        // make file-clone info table
        try {
            creationDAO.createCloneInfo();
        } catch (SQLSyntaxErrorException e) {
        } catch (SQLException e) {
        }
        _filecloneDAO = new InsertionCloneInfoDAO(_transactionManager);
	}
	
	public SelectionHashDAO getHashDAO() {
		return _hashDAO;
	}
	
	public InsertionCloneInfoDAO getFileCloneDAO() {
		return _filecloneDAO;
	}
	
	public void close() throws SQLException {
		_transactionManager.close();
	}
}
