package jp.ac.osaka_u.ist.sel.similarity.database;

/**
 * SQL generator for FCFinder.
 * 
 * @author ysk-ssk
 *
 */
public class SQLGenerator {
	
	public static String getSelectStatement(TableType table, ColumnName[] columns) {
		String sql = "select ";
		for (int i=0;i<columns.length;i++) {
			sql += columns[i];
			if (i < columns.length-1) {
				sql += ',';
			}
		}
		sql += " from " + table;
		return sql;
	}
	
	public static String getWhereSelectStatement(TableType table, ColumnName[] columns, ColumnName constraintType, String constraintValue) {
		String sql = "select ";
		for (int i=0;i<columns.length;i++) {
			sql += columns[i];
			if (i < columns.length-1) {
				sql += ',';
			}
		}
		sql += " from " + table;
		sql += " where " + constraintType + " = " + constraintValue;
		return sql;
	}
	
	public static String getWhereSelectStatement(TableType table, ColumnName[] columns, ColumnName constraintType, int constraintValue) {
		return getWhereSelectStatement(table,columns,constraintType,String.valueOf(constraintValue));
	}
	
	public static String getSelectMaxStatement(TableType table, ColumnName column) {
		String sql = "select MAX(";
		sql += column;
		sql += ") from " + table;
		return sql;
	}
	
	// TODO
    public static String getUpdateStatement(TableType table, ColumnName[] columns, String[] values, ColumnName whereColumn, String whereValue) {
        assert(columns.length == values.length);
        String sql = "update " + table + " set ";
        for (int i=0;i<columns.length;i++) {
            sql += columns[i] + "=" + values[i];
            if (i < columns.length-1) {
                sql += ',';
            }
        }
        sql += " where " + whereColumn + "=" + whereValue;
        return sql;
    }
    
}
