connect 'jdbc:derby:easydb;create=true';

CREATE TABLE DOMAIN_INFO (
  ID INT NOT NULL PRIMARY KEY
, NAME VARCHAR(1024) NOT NULL
);

CREATE INDEX IDX_DOMAIN_INFO_ID ON DOMAIN_INFO(ID);
CREATE INDEX IDX_DOMAIN_INFO_NAME ON DOMAIN_INFO(NAME);

CREATE TABLE FILE_INFO (
  ID INT NOT NULL PRIMARY KEY -- Last ID = 2^32-1 = 2147483648-1
, PATH VARCHAR(1024) NOT NULL
, EXT VARCHAR(64) NOT NULL -- file extension
, FILE_SIZE BIGINT NOT NULL -- file size
, DOMAIN_ID INT NOT NULL
, FOREIGN KEY (DOMAIN_ID) REFERENCES DOMAIN_INFO(ID) -- app id
);

CREATE INDEX IDX_FILE_INFO_ID ON FILE_INFO(ID);
CREATE INDEX IDX_FILE_INFO_PATH ON FILE_INFO(PATH);
CREATE INDEX IDX_FILE_INFO_EXT ON FILE_INFO(EXT);
CREATE INDEX IDX_FILE_INFO_SIZE ON FILE_INFO(FILE_SIZE);

exit;

