package jp.ac.osaka_u.ist.sel.similarity.database;

/**
 * Column names.
 * 
 * @author ysk-ssk
 *
 */
public enum ColumnName {
    ID,
    NAME,
    PATH,
    EXT,
    FILE_SIZE,
    DOMAIN_ID,
    NUM_OF_TOK,
    MD5_HASH,
    GROUP_ID,
    MODIFIED,
    ;

    public static String getColumnType(ColumnName columnName) {
        switch (columnName) {
        case ID:
            return "INT";
        case NAME:
            return "VARCHAR(" + getColumnLength(columnName) + ")";
        case PATH:
            return "VARCHAR(" + getColumnLength(columnName) + ")";
        case EXT:
            return "VARCHAR(" + getColumnLength(columnName) + ")";
        case FILE_SIZE:
            return "BIGINT";
        case DOMAIN_ID:
            return "INT";
        case NUM_OF_TOK:
            return "INT";
        case MD5_HASH:
            return "BLOB(" + getColumnLength(columnName) + ")";
        case GROUP_ID:
            return "INT";
        case MODIFIED:
            return "BIGINT";
        default:
        }
        return null;
    }

    public static int getColumnLength(ColumnName columnName) {
        switch (columnName) {
        case ID:
            return 1;
        case NAME:
            return 1024;
        case PATH:
            return 1024;
        case EXT:
            return 64;
        case FILE_SIZE:
            return 1;
        case DOMAIN_ID:
            return 1;
        case NUM_OF_TOK:
            return 1;
        case MD5_HASH:
            return 32;
        case GROUP_ID:
            return 1;
        case MODIFIED:
            return 1;
        default:
        }
        return 0;
    }
}

