package jp.ac.osaka_u.ist.sel.similarity.database;

import java.io.File;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

/**
 * Standard DAO class in FCRegister.
 * 
 * @author ysk-ssk
 *
 */
public abstract class AbstractDAO {
	private TransactionManager _transactionManager;

	public AbstractDAO(TransactionManager transactionManager) throws SQLException {
		_transactionManager = transactionManager;
	}

	protected void commit() throws SQLException {
		_transactionManager.commit();
	}
	
	protected ResultSet executeQuery(PreparedStatement pstmt) throws SQLException {
		return _transactionManager.executeQuery(pstmt);
	}

	protected int executeUpdate(PreparedStatement pstmt) throws SQLException {
		return _transactionManager.executeUpdate(pstmt);
	}
	
	protected PreparedStatement prepareStatement(String sql) throws SQLException {
		return _transactionManager.prepareStatement(sql);
	}

	/**
	 * Return the result (type:int) from the database.
	 * 
	 * @param rset
	 * @return
	 * @throws SQLException
	 */
	protected int getIntegerValue(ResultSet rset) throws SQLException {
		int value = -1;
		while ( rset.next() ) {
			value = rset.getInt(1);
		}
		rset.close();
		return value;
	}

	/**
	 * Get file path from files.
	 * This method defines how to archive file path in this DAO class.
	 * Ex. canonical path, absolute path, or file name.
	 * 
	 * the default is canonical path.
	 * 
	 * @param file
	 * @return
	 * @throws IOException
	 */
	public static String getPath(File file) throws IOException {
		return file.getCanonicalPath();
	}
}
