package jp.ac.osaka_u.ist.sel.similarity.csv.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.ac.osaka_u.ist.sel.similarity.database.AbstractDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.database.SQLGenerator;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

/**
 * DAO class for HashInfo table.
 * Select hash values from HashInfo table.
 * 
 * @author ysk-ssk
 *
 */
public class SelectionHashDAO extends AbstractDAO {
    
	public SelectionHashDAO(TransactionManager transactionManager)
            throws SQLException {
        super(transactionManager);
    }

    public List<Byte> getHash(int fileId) throws SQLException {
        List<Byte> hashValue = new ArrayList<Byte>();
	    
        ColumnName[] columns = {ColumnName.MD5_HASH};
        String sql = SQLGenerator.getWhereSelectStatement(TableType.HASH_INFO, columns, ColumnName.ID, String.valueOf(fileId));
        PreparedStatement pstmt = prepareStatement(sql);
        ResultSet results = executeQuery(pstmt);
        if (!results.next()) {
            return null;
        }
        for (byte hashElement : results.getBytes(1)) {
            hashValue.add(hashElement);
        }
        
        return hashValue;
	}
	
}
