package jp.ac.osaka_u.ist.sel.similarity.csv.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import jp.ac.osaka_u.ist.sel.similarity.database.AbstractDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.database.SQLGenerator;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

/**
 * DAO class for DomainInfo table.
 * Get domain data from DomainInfo table.
 * 
 * @author ysk-ssk
 *
 */
public class SelectionDomainDAO extends AbstractDAO {
    private Map<Integer,String> mappedData;
	
	public SelectionDomainDAO(TransactionManager transactionManager)
			throws SQLException {
		super(transactionManager);
		mappedData  = getMappedData();
	}
	
	private Map<Integer,String> getMappedData() throws SQLException {
	    Map<Integer,String> mappedData = new HashMap<Integer,String>();
	    
        // create sql
        ColumnName[] columns = {ColumnName.ID,ColumnName.NAME};
        String sql = SQLGenerator.getSelectStatement(TableType.DOMAIN_INFO, columns);
        // prepare the statement
        PreparedStatement pstmt = prepareStatement(sql);
        // execute
        ResultSet results = executeQuery(pstmt);
        while (results.next()) {
            int fileId = results.getInt(1);
            String name = results.getString(2);
            mappedData.put(fileId,name);
        }
        
        return mappedData;
	}
	
	public String getName(int domainId) {
	    return mappedData.get(domainId);
	}

}
