package jp.ac.osaka_u.ist.sel.similarity.csv.database;

import java.sql.SQLException;

import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

/**
 * This class has following class instances:
 * 
 * * TransactionManager
 * * DAO class for CloneInfo table
 * * DAO class for FileInfo table
 * * DAO class for DomainInfo table
 * * DAO class for HashInfo table
 * 
 * When you create an instance of this class, the instance initializes all DAO classes.
 * And you need to close after all executions.
 * 
 * @author ysk-ssk
 *
 */
public class CsvWriterDAOManager {
	private TransactionManager _transactionManager;
    private SelectionCloneDAO _filecloneDAO;
	private SelectionFileDAO _fileDAO;
    private SelectionDomainDAO _domainDAO;
    private SelectionHashDAO _hashDAO;
	
	public CsvWriterDAOManager(String dbPath) throws SQLException {
		_transactionManager = new TransactionManager(dbPath);
        _filecloneDAO = new SelectionCloneDAO(_transactionManager);
        _fileDAO = new SelectionFileDAO(_transactionManager);
        _domainDAO = new SelectionDomainDAO(_transactionManager);
        _hashDAO = new SelectionHashDAO(_transactionManager);
	}
	
	public SelectionCloneDAO getFileCloneDAO() {
		return _filecloneDAO;
	}
	
    public SelectionFileDAO getFileDAO() {
        return _fileDAO;
    }
    
    public SelectionDomainDAO getDomainDAO() {
        return _domainDAO;
    }
    
    public SelectionHashDAO getHashDAO() {
        return _hashDAO;
    }
    
	public void close() throws SQLException {
		_transactionManager.close();
	}
}
