package jp.ac.osaka_u.ist.sel.similarity.commons;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/**
 * Read text lines from the file contents.
 * 
 * @author ysk-ssk
 *
 */
public class TokenReader {
	private final static Pattern _chLine = Pattern.compile("\n");
	/**
	 * is an utility class.
	 */
	private TokenReader() {
	}
	
	public static List<String> getTokenList(String text) throws Exception {
		StringReader sReader = new StringReader(text);
		BufferedReader bReader = new BufferedReader(sReader);

		List<String> tokenList = new ArrayList<String>();
		try {
			String line = null;
			line = bReader.readLine();
			while (line != null) {
				line = _chLine.matcher(line).replaceAll("");
				tokenList.add(line);
				line = bReader.readLine();
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			try {
				if (bReader != null) {
					bReader.close();
				}
				if (sReader != null) {
					sReader.close();
				}
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return tokenList;
	}

}
