package jp.ac.osaka_u.ist.sel.similarity.commons;


import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

/**
 * http://blog.livedoor.jp/froo/archives/50087390.html
 */
public class TextReader {
    /**
     * is an utitily class.
     */
    private TextReader() {
    }

	/**
	 * Read text from a Reader class.
	 * @param in
	 * @return
	 * @throws IOException
	 */
	private static String readText(Reader in) throws IOException {
		BufferedReader inReader = new BufferedReader(in);
		StringBuffer sBuf = new StringBuffer();

		int ch;
		while ((ch = inReader.read()) != -1) {
			sBuf.append((char) ch);
		}

		if (sBuf.toString() == null) {
			return sBuf.substring(0);
		}
		return sBuf.toString();
	}

	/**
	 * Read textlines from a file.
	 * @param filename
	 * @return file content text
	 * @throws IOException
	 */
	public static String readText(String filename) throws IOException {
		FileReader fReader = null;
		BufferedReader bReader = null;
		String text = null;

		try {
			fReader = new FileReader(filename);
			bReader = new BufferedReader(fReader);
			text = readText(bReader);
		} catch (IOException e) {
			throw e;
		} finally {
			if (bReader != null) {
				bReader.close();
			}
			if (fReader != null) {
				fReader.close();
			}
		}
//		return text;
		return getUnicodeString(text);
	}

	private static String getUnicodeString(String text) throws UnsupportedEncodingException {
		if (StringValidator.isUTF8(text)) {
			return getUnicodeString(text,StringValidator._UTF_8);
		}
		if (StringValidator.isEUC(text)) {
			return getUnicodeString(text,StringValidator._euc_jp);
		}
		if (StringValidator.isSJIS(text)) {
			return getUnicodeString(text,StringValidator._SJIS);
		}
		if (StringValidator.isWindows31j(text)) {
			return getUnicodeString(text,StringValidator._Windows_31j);
		}
		return null;
	}
	
	private static String getUnicodeString(String s, String charset) throws UnsupportedEncodingException {
		return new String(s.getBytes(charset), StringValidator._UTF_8);
	}
}
