package jp.ac.osaka_u.ist.sel.similarity.commons;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Supported languages in this tool.
 * 
 * @author ysk-ssk
 *
 */
public class SupportedLanguage {
	public static final String _KEY_LANG_C = "C";
	public static final String _KEY_LANG_CPP = "CPP";
	public static final String _KEY_LANG_JAVA = "JAVA";
	
	/**
	 * Relative extensions of supported languages.
	 * 
	 * @author ysk-ssk
	 *
	 */
	public class FileExtensions {
		private FileExtensions() {
		}
		
		public final static String _EXT_C_C = "c";
		public final static String _EXT_C_H = "h";
		public final static String _EXT_CPP_CPP = "cpp";
		public final static String _EXT_JAVA = "java";
	}
	
	/**
	 * is an utility class.
	 */
	private SupportedLanguage() {
	}

	public static Set<String> getTargetExtensionSet(String lang) {
		Set<String> extensions = new TreeSet<String>();
		if (_KEY_LANG_CPP.equals(lang.toUpperCase())) {
			extensions.add(FileExtensions._EXT_C_C);
			extensions.add(FileExtensions._EXT_C_H);
			extensions.add(FileExtensions._EXT_CPP_CPP);
		} else if (_KEY_LANG_C.equals(lang.toUpperCase())) {
			extensions.add(FileExtensions._EXT_C_C);
			extensions.add(FileExtensions._EXT_C_H);
		} else if (_KEY_LANG_JAVA.equals(lang.toUpperCase())) {
			extensions.add(FileExtensions._EXT_JAVA);
		}
		return extensions;
	}

	public static String getTargetLanguage(String fileExtension) {
		if (fileExtension.equals(FileExtensions._EXT_C_C)) {
			return _KEY_LANG_C;
		} else if (fileExtension.equals(FileExtensions._EXT_C_H)) {
			return _KEY_LANG_C;
		} else if (fileExtension.equals(FileExtensions._EXT_CPP_CPP)) {
			return _KEY_LANG_CPP;
		} else if (fileExtension.equals(FileExtensions._EXT_JAVA)) {
			return _KEY_LANG_JAVA;
		}
		return null;
	}
	
    private static Pattern _periodPattern = Pattern.compile(".*\\.([^\\.]*)$");
    public static String getFileExtension(String filePath) {
        Matcher periodMatcher = _periodPattern.matcher(filePath);
        if (!periodMatcher.find()) {
            return "";
        }
        return periodMatcher.group(1);
    }

}
