package jp.ac.osaka_u.ist.sel.similarity.commons;

import java.io.UnsupportedEncodingException;

/**
 * Validate character codes in a text file.
 * 
 * Hint:
 * http://d.hatena.ne.jp/cero-t/20100204/1265302329
 * 
 * @author ysk-ssk
 *
 */
public class StringValidator {
	public static final String _Windows_31j = "Windows-31j";
	public static final String _SJIS = "SJIS";
	public static final String _euc_jp = "euc-jp";
	public static final String _UTF_8 = "UTF-8";

	/**
	 * is an utility class.
	 */
	private StringValidator() {
	}
	
	private static boolean checkCharacterCode(String str, String encoding) {
		if (str == null) {
			return true;
		}

		try {
			byte[] bytes = str.getBytes(encoding);
			return str.equals(new String(bytes, encoding));
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}
	}

	public static boolean isWindows31j(String str) {
		return checkCharacterCode(str, _Windows_31j);
	}

	public static boolean isSJIS(String str) {
		return checkCharacterCode(str, _SJIS);
	}

	public static boolean isEUC(String str) {
		return checkCharacterCode(str, _euc_jp);
	}

	public static boolean isUTF8(String str) {
		return checkCharacterCode(str, _UTF_8);
	}
}
