package jp.ac.osaka_u.ist.sel.similarity.commons;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/**
 * Setting singleton class.
 * Store preference information.
 * 
 * @author Ares
 *
 */
public class Settings {
    public enum ListMode {
        DIR_LIST,
        FILE_LIST
    }
    
    // target languages
    private Set<String> _languages = new TreeSet<String>();
    
    // detect files with all extensions, or not
    private boolean _detectAll = false;
    
    // NG words
	private Set<String> _ngWords = new TreeSet<String>();
	
	// working path
	private String _workingPath = null;
	
	// database name
	public static String _defaultDatabasePath = "easydb";
	
	// database path
	private String _databasePath = _defaultDatabasePath;

    // minimum size of the number of tokens
    private int _minNOT = 15;
    
    // targets are directories or files
    private ListMode _listMode = ListMode.DIR_LIST;
    
    // target directories
    private Set<String> _directorySet = new TreeSet<String>();
    
    // target files
    private Map<String,Set<String>> _fileMap = new HashMap<String,Set<String>>();
    
    private String _csvPath = null;
    
	private static Settings _settings = new Settings();
	
	/**
	 * is a singleton class.
	 */
	private Settings() {
	}
	
	public static Settings getInstance() {
		return _settings;
	}
	
    public void reset() {
        this._languages.clear();
        this._directorySet.clear();
        this._ngWords.clear();
    }
    
    public void setListMode(ListMode listMode) {
        _listMode = listMode;
    }
    
	public ListMode getListMode() {
	    return _listMode;
	}
	
	public void setWorkingPath(String workingPath) {
		_workingPath = workingPath;
	}

	public String getWorkingPath() {
		return _workingPath;
	}
	
	public void setDatabasePath(String databasePath) {
	    _databasePath = databasePath;
	}
	
	public String getDatabasePath() {
		return _databasePath;
	}

	public void addTargetLanguages(Collection<String> languages) {
		_languages.addAll(languages);
	}

	public Set<String> getTargetLanguages() {
		return _languages;
	}
	
	public void addDirectories(Collection<String> directoryPaths) {
		_directorySet.addAll(directoryPaths);
	}

	public Set<String> getTargetDirectories() {
		return _directorySet;
	}

	public void addNGWords(Collection<String> ngWords) {
		_ngWords.addAll(ngWords);
	}
	
	public Set<String> getNGWords() {
		return _ngWords;
	}

    public void setFileMap(Map<String, Set<String>> fileMap) {
        _fileMap = fileMap;
    }
    
    public Map<String,Set<String>> getFileMap() {
        return _fileMap;
    }
	
    public int getMinNOT() {
        return _minNOT;
    }

    public void setMinNOT(int minNOT) {
        this._minNOT = minNOT;
    }

    public boolean isDetectAll() {
        return _detectAll;
    }

    public void setDetectAll(boolean detectAll) {
        this._detectAll = detectAll;
    }

    public void setCsvPath(String csvPath) {
        this._csvPath = csvPath;
    }
    
    public String getCsvPath() {
        return _csvPath;
    }
}
