/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FileMapXmlParser {
    private FileMapXmlParser() {
    }

    public static Map<String, Set<String>> parseXml(String xmlPath) throws ParserConfigurationException, SAXException, IOException {
        HashMap<String, Set<String>> filePathMap = new HashMap<String, Set<String>>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(xmlPath);
        Element rootElement = document.getDocumentElement();
        if (!rootElement.getTagName().equals("register-target")) {
            throw new RuntimeException("Unknown tag: " + rootElement.getTagName());
        }
        NodeList domainElements = rootElement.getElementsByTagName("domain");
        int i = 0;
        while (i < domainElements.getLength()) {
            Element domainElement = (Element)domainElements.item(i);
            if (!domainElement.hasAttribute("basepath")) {
                throw new RuntimeException("basepath attribute not found in domain tag.");
            }
            String basepath = domainElement.getAttribute("basepath");
            HashSet<String> filePathSet = new HashSet<String>();
            NodeList fileElements = domainElement.getElementsByTagName("file");
            int j = 0;
            while (j < fileElements.getLength()) {
                Element fileElement = (Element)fileElements.item(j);
                if (!fileElement.hasAttribute("path")) {
                    throw new RuntimeException("path attribute not found in file tag.");
                }
                String path = fileElement.getAttribute("path");
                filePathSet.add(path);
                ++j;
            }
            filePathMap.put(basepath, filePathSet);
            ++i;
        }
        return filePathMap;
    }

    public static void outputXml(Map<String, Set<String>> filePathMap, String xmlPath) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        FileWriter fileWriter = null;
        XMLStreamWriter xmlWriter = null;
        File xmlFile = new File(xmlPath);
        if (xmlFile.exists() && !xmlFile.canWrite()) {
            throw new RuntimeException("Can not write: " + xmlPath);
        }
        try {
            fileWriter = new FileWriter(xmlPath);
            xmlWriter = factory.createXMLStreamWriter(fileWriter);
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.writeStartElement("register-target");
            for (String basepath : filePathMap.keySet()) {
                xmlWriter.writeStartElement("domain");
                xmlWriter.writeAttribute("basepath", basepath);
                Set<String> filePathSet = filePathMap.get(basepath);
                for (String path : filePathSet) {
                    xmlWriter.writeEmptyElement("file");
                    xmlWriter.writeAttribute("path", path);
                }
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
        }
        finally {
            try {
                if (xmlWriter != null) {
                    xmlWriter.close();
                }
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

