/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DirListXmlParser {
    private DirListXmlParser() {
    }

    public static List<String> parseXml(String xmlPath) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<String> dirPathList = new ArrayList<String>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(xmlPath);
        Element rootElement = document.getDocumentElement();
        if (!rootElement.getTagName().equals("register-target")) {
            throw new RuntimeException("Unknown tag: " + rootElement.getTagName());
        }
        NodeList domainElements = rootElement.getElementsByTagName("domain");
        int i = 0;
        while (i < domainElements.getLength()) {
            Element domainElement = (Element)domainElements.item(i);
            if (!domainElement.hasAttribute("basepath")) {
                throw new RuntimeException("basepath attribute not found in domain tag.");
            }
            String basepath = domainElement.getAttribute("basepath");
            dirPathList.add(basepath);
            ++i;
        }
        return dirPathList;
    }

    public static void outputXml(List<String> dirPathList, String xmlPath) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        FileWriter fileWriter = null;
        XMLStreamWriter xmlWriter = null;
        File xmlFile = new File(xmlPath);
        if (xmlFile.exists() && !xmlFile.canWrite()) {
            throw new RuntimeException("Can not write: " + xmlPath);
        }
        try {
            fileWriter = new FileWriter(xmlPath);
            xmlWriter = factory.createXMLStreamWriter(fileWriter);
            xmlWriter.writeStartDocument("UTF-8", "1.0");
            xmlWriter.writeStartElement("register-target");
            for (String dirPath : dirPathList) {
                xmlWriter.writeEmptyElement("domain");
                xmlWriter.writeAttribute("basepath", dirPath);
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
        }
        finally {
            try {
                if (xmlWriter != null) {
                    xmlWriter.close();
                }
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

