/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.register.database;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.similarity.database.AbstractDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.database.SQLGenerator;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

public class InsertionFileDAO
extends AbstractDAO {
    private int _maxId = 1;
    private Map<FileInfo, Integer> _fileToIdMapping = new HashMap<FileInfo, Integer>();

    public InsertionFileDAO(TransactionManager transactionManager) throws SQLException {
        super(transactionManager);
        this.initializeNameToIdMapping();
    }

    private void initializeNameToIdMapping() throws SQLException {
        ColumnName[] columns = new ColumnName[]{ColumnName.ID, ColumnName.PATH, ColumnName.DOMAIN_ID};
        String sql = SQLGenerator.getSelectStatement(TableType.FILE_INFO, columns);
        PreparedStatement pstmt = this.prepareStatement(sql);
        ResultSet results = this.executeQuery(pstmt);
        while (results.next()) {
            FileInfo fileInfo = new FileInfo(results.getString(2), results.getInt(3));
            this._fileToIdMapping.put(fileInfo, results.getInt(1));
        }
        this._maxId = this.getMaxId();
        this._maxId = this._maxId != -1 ? ++this._maxId : 1;
    }

    private int getMaxId() throws SQLException {
        String sql = SQLGenerator.getSelectMaxStatement(TableType.FILE_INFO, ColumnName.ID);
        return this.getIntegerValue(this.executeQuery(this.prepareStatement(sql)));
    }

    public boolean insert(String filePath, String ext, long fileSize, int domainId) throws SQLException {
        Set<FileInfo> fileInfoSet = this._fileToIdMapping.keySet();
        FileInfo fileInfo = new FileInfo(filePath, domainId);
        if (fileInfoSet != null && fileInfoSet.contains(fileInfo)) {
            return true;
        }
        PreparedStatement pstmt = null;
        String sql = "insert into " + (Object)((Object)TableType.FILE_INFO) + " values (?,?,?,?,?)";
        pstmt = this.prepareStatement(sql);
        pstmt.setInt(1, this._maxId);
        pstmt.setString(2, filePath);
        pstmt.setString(3, ext);
        pstmt.setLong(4, fileSize);
        pstmt.setInt(5, domainId);
        if (this.executeUpdate(pstmt) == 1) {
            this._fileToIdMapping.put(fileInfo, this._maxId++);
            return true;
        }
        return false;
    }

    public static String getPath(File file) {
        return file.getPath();
    }

    private class FileInfo {
        private final String _name;
        private final int _domainId;

        public FileInfo(String path, int domainId) {
            this._name = path;
            this._domainId = domainId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this._domainId;
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileInfo other = (FileInfo)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this._domainId != other._domainId) {
                return false;
            }
            return !(this._name == null ? other._name != null : !this._name.equals(other._name));
        }

        private InsertionFileDAO getOuterType() {
            return InsertionFileDAO.this;
        }
    }
}

