/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.register.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.similarity.database.AbstractDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.database.SQLGenerator;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

public class InsertionDomainDAO
extends AbstractDAO {
    private int _maxId = 1;
    private Map<String, Integer> _domainToIdMapping = new HashMap<String, Integer>();

    public InsertionDomainDAO(TransactionManager transactionManager) throws SQLException {
        super(transactionManager);
        this.initializeNameToIdMapping();
    }

    private void initializeNameToIdMapping() throws SQLException {
        ColumnName[] columns = new ColumnName[]{ColumnName.ID, ColumnName.NAME};
        String sql = SQLGenerator.getSelectStatement(TableType.DOMAIN_INFO, columns);
        PreparedStatement pstmt = this.prepareStatement(sql);
        ResultSet results = this.executeQuery(pstmt);
        while (results.next()) {
            this._domainToIdMapping.put(results.getString(2), results.getInt(1));
        }
        this._maxId = this.getMaxId();
        this._maxId = this._maxId != -1 ? ++this._maxId : 1;
    }

    private int getMaxId() throws SQLException {
        String sql = SQLGenerator.getSelectMaxStatement(TableType.DOMAIN_INFO, ColumnName.ID);
        return this.getIntegerValue(this.executeQuery(this.prepareStatement(sql)));
    }

    public int getId(String name) {
        Integer id = this._domainToIdMapping.get(name);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public boolean insert(String domainName) throws SQLException {
        Set<String> domainNameSet = this._domainToIdMapping.keySet();
        if (domainNameSet != null && domainNameSet.contains(domainName)) {
            return true;
        }
        String sql = "";
        PreparedStatement pstmt = null;
        sql = "insert into " + (Object)((Object)TableType.DOMAIN_INFO) + " values (?,?)";
        pstmt = this.prepareStatement(sql);
        pstmt.setInt(1, this._maxId);
        pstmt.setString(2, domainName);
        if (this.executeUpdate(pstmt) == 1) {
            this._domainToIdMapping.put(domainName, this._maxId++);
            return true;
        }
        return false;
    }
}

