/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.register;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.similarity.commons.FileSearch;
import jp.ac.osaka_u.ist.sel.similarity.commons.Settings;
import jp.ac.osaka_u.ist.sel.similarity.commons.SupportedLanguage;
import jp.ac.osaka_u.ist.sel.similarity.register.FileInfoRegister;
import jp.ac.osaka_u.ist.sel.similarity.register.database.FileRegisterDAOManager;

public class FileSearchRegister
extends FileInfoRegister {
    private FileSearch _searcher = new FileSearch();
    private Set<String> _extensions = new HashSet<String>();

    public FileSearchRegister(FileRegisterDAOManager daoManager) throws SQLException, IOException {
        super(daoManager);
        Set<String> languages = Settings.getInstance().getTargetLanguages();
        for (String lang : languages) {
            Set<String> extensions = SupportedLanguage.getTargetExtensionSet(lang);
            this._extensions.addAll(extensions);
        }
    }

    public void search() throws IOException, SQLException {
        this.registerNewDomain();
        File[] files = null;
        String targetRegix = "";
        int i = 0;
        if (Settings.getInstance().isDetectAll()) {
            targetRegix = "*";
        } else {
            for (String ext : this._extensions) {
                if (i++ > 0) {
                    targetRegix = String.valueOf(targetRegix) + "|";
                }
                targetRegix = String.valueOf(targetRegix) + "*." + ext + "$";
            }
        }
        try {
            this._searcher.clear();
            files = this._searcher.listFiles(this._domainName, targetRegix);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return;
        }
        if (files.length <= 0) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String ext = SupportedLanguage.getFileExtension(file.getName());
            this.registerFile(file, ext);
            ++n2;
        }
    }
}

