/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.register;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Set;
import java.util.regex.Pattern;
import jp.ac.osaka_u.ist.sel.similarity.commons.Settings;
import jp.ac.osaka_u.ist.sel.similarity.commons.SupportedLanguage;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.register.database.FileRegisterDAOManager;
import jp.ac.osaka_u.ist.sel.similarity.register.database.InsertionDomainDAO;
import jp.ac.osaka_u.ist.sel.similarity.register.database.InsertionFileDAO;
import org.apache.log4j.Logger;

public class FileInfoRegister {
    protected final Logger _log = Logger.getLogger((String)"FileInfoRegister");
    protected String _domainName = null;
    protected InsertionDomainDAO _domainDAO;
    protected InsertionFileDAO _fileDAO;
    private Pattern _ignoreFileRegularExpression;

    protected FileInfoRegister() {
        this.defineIgnoreTarget();
    }

    public FileInfoRegister(FileRegisterDAOManager daoManager) {
        this._domainDAO = daoManager.getDomainDAO();
        this._fileDAO = daoManager.getFileDAO();
        this.defineIgnoreTarget();
    }

    private void defineIgnoreTarget() {
        String ignoreRegix = "";
        int i = 0;
        for (String ngWord : Settings.getInstance().getNGWords()) {
            if (i != 0) {
                ignoreRegix = String.valueOf(ignoreRegix) + "|";
            }
            ignoreRegix = String.valueOf(ignoreRegix) + "(.*" + ngWord + ".*)";
            ++i;
        }
        this._ignoreFileRegularExpression = Pattern.compile(ignoreRegix, 2);
    }

    public boolean setDomainName(String domainName) throws IOException {
        assert (domainName != null);
        if (domainName.length() > ColumnName.getColumnLength(ColumnName.NAME)) {
            return false;
        }
        this._domainName = domainName;
        return true;
    }

    public void registerFileSet(Set<String> filePathSet) throws SQLException {
        this.registerNewDomain();
        for (String filePath : filePathSet) {
            if (!new File(filePath).canRead()) {
                System.err.println("Invalid path: " + filePath);
                continue;
            }
            String ext = SupportedLanguage.getFileExtension(filePath);
            this.registerFile(new File(filePath), ext);
        }
    }

    protected void registerNewDomain() throws SQLException {
        assert (this._domainName != null);
        int domainId = -1;
        domainId = this._domainDAO.getId(this._domainName);
        if (domainId <= 0 && !this._domainDAO.insert(this._domainName)) {
            this._log.error((Object)("Can not insert:\t" + this._domainName));
        }
    }

    protected void registerFile(File file, String ext) throws SQLException {
        String filePath = InsertionFileDAO.getPath(file);
        if (filePath == null) {
            this._log.error((Object)("Can not get the path.\t" + this._domainName + "\t:" + file));
            return;
        }
        if (this._ignoreFileRegularExpression.matcher(filePath).matches()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("NG:\t" + filePath));
            }
            return;
        }
        if (filePath.length() > ColumnName.getColumnLength(ColumnName.PATH)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("too long path:\t" + filePath));
            }
            return;
        }
        long fileSize = file.length();
        if (!this._fileDAO.insert(filePath, ext, fileSize, this._domainDAO.getId(this._domainName))) {
            this._log.info((Object)("Can not insert:\t" + filePath));
        }
    }
}

