/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.hash.tokenizer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import jp.ac.osaka_u.ist.sel.similarity.commons.Settings;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.hash.database.InsertionTokenInfoDAO;
import jp.ac.osaka_u.ist.sel.similarity.hash.database.SelectionFileDAO;
import jp.ac.osaka_u.ist.sel.similarity.hash.parser.TokenStream;
import org.apache.log4j.Logger;

public abstract class TokenInfoRegister {
    private final Logger _log = Logger.getLogger((String)"TokenInfoRegister");
    private final String _tokenDir = Settings.getInstance().getWorkingPath();
    private final InsertionTokenInfoDAO _tokenDAO;

    public TokenInfoRegister(InsertionTokenInfoDAO tokenDAO) {
        this._tokenDAO = tokenDAO;
    }

    private void makeDirToPreserve(String path) throws IOException {
        File parent = new File(path).getParentFile();
        if (parent.getParentFile() != null && !parent.getParentFile().exists()) {
            this.makeDirToPreserve(SelectionFileDAO.getPath(parent));
        }
        if (!parent.mkdir() && !parent.exists()) {
            this._log.error((Object)("Can not make a directory. " + parent));
            return;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("mkdir: " + parent));
        }
    }

    protected abstract TokenStream getTokenStream(Reader var1);

    public byte[] calculateHash(int fileId, String sourcePath) throws IOException, NoSuchAlgorithmException, SQLException {
        byte[] digest;
        File sourceFile;
        String tokenPath = null;
        if (this._tokenDir != null) {
            tokenPath = String.valueOf(this._tokenDir) + "/" + fileId;
        }
        if (!(sourceFile = new File(sourcePath)).exists()) {
            this._log.error((Object)("No such file:\t" + sourcePath));
            return null;
        }
        FileReader fileReader = new FileReader(sourceFile);
        TokenStream readStream = this.getTokenStream(fileReader);
        if (tokenPath != null) {
            this.makeDirToPreserve(tokenPath);
        }
        FileOutputStream fWriter = null;
        OutputStreamWriter bWriter = null;
        int count = 0;
        try {
            if (tokenPath != null) {
                fWriter = new FileOutputStream(tokenPath);
                bWriter = new OutputStreamWriter((OutputStream)fWriter, "UTF-8");
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            String token = null;
            try {
                while ((token = readStream.next()) != null) {
                    token = String.valueOf(token) + '\n';
                    byte[] tokenByte = token.getBytes();
                    md.update(tokenByte, 0, tokenByte.length);
                    if (bWriter != null) {
                        bWriter.write(token);
                    }
                    ++count;
                }
            }
            catch (Throwable e) {
                this._log.error((Object)("Parse error:\t" + sourcePath));
                this._log.error((Object)(String.valueOf(readStream.getLine()) + "," + readStream.getColumn() + " before '" + token + "'"));
                this._log.error((Object)e.getMessage());
                if (bWriter != null) {
                    bWriter.close();
                }
                if (fWriter != null) {
                    fWriter.close();
                }
                if (fileReader != null) {
                    fileReader.close();
                }
                return null;
            }
            digest = md.digest();
        }
        finally {
            if (bWriter != null) {
                bWriter.close();
            }
            if (fWriter != null) {
                fWriter.close();
            }
            if (fileReader != null) {
                fileReader.close();
            }
        }
        if (this._log.isDebugEnabled() && tokenPath != null) {
            this._log.debug((Object)("token:\t" + tokenPath));
        }
        if (count < Settings.getInstance().getMinNOT()) {
            return null;
        }
        if (tokenPath != null) {
            this.registerToken(fileId, tokenPath, count);
        }
        return digest;
    }

    private void registerToken(int fileId, String tokenPath, int tokenCount) throws SQLException {
        if (tokenPath.length() > ColumnName.getColumnLength(ColumnName.PATH)) {
            this._log.error((Object)("too long path:\t" + tokenPath));
            return;
        }
        File file = new File(tokenPath);
        long fileSize = file.length();
        if (!this._tokenDAO.insert(fileId, tokenPath, tokenCount, fileSize)) {
            this._log.error((Object)("Can not register:\t" + tokenPath));
            return;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("register:\t" + tokenPath));
        }
    }
}

