/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.hash.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.similarity.database.AbstractDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.database.SQLGenerator;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

public class SelectionFileDAO
extends AbstractDAO {
    private Map<Integer, FileInfo> _fileIdToInfoMapping = new HashMap<Integer, FileInfo>();

    public SelectionFileDAO(TransactionManager transactionManager) throws SQLException {
        super(transactionManager);
        this.initializeIdToNameMapping();
    }

    private void initializeIdToNameMapping() throws SQLException {
        ColumnName[] columns = new ColumnName[]{ColumnName.ID, ColumnName.EXT, ColumnName.FILE_SIZE};
        String sql = SQLGenerator.getSelectStatement(TableType.FILE_INFO, columns);
        PreparedStatement pstmt = this.prepareStatement(sql);
        ResultSet results = this.executeQuery(pstmt);
        while (results.next()) {
            int fileId = results.getInt(1);
            String ext = results.getString(2);
            long size = results.getLong(3);
            FileInfo fileInfo = new FileInfo(ext, size);
            this._fileIdToInfoMapping.put(fileId, fileInfo);
        }
    }

    public Set<Integer> getFileIdSet() {
        return this._fileIdToInfoMapping.keySet();
    }

    public String getFilePath(int fileId) throws SQLException {
        assert (this._fileIdToInfoMapping.get(fileId) != null);
        ColumnName[] columns = new ColumnName[]{ColumnName.PATH};
        String sql = SQLGenerator.getWhereSelectStatement(TableType.FILE_INFO, columns, ColumnName.ID, String.valueOf(fileId));
        PreparedStatement pstmt = this.prepareStatement(sql);
        ResultSet results = this.executeQuery(pstmt);
        if (!results.next()) {
            return null;
        }
        String path = results.getString(1);
        return path;
    }

    public String getFileExt(int fileId) {
        assert (this._fileIdToInfoMapping.get(fileId) != null);
        return this._fileIdToInfoMapping.get((Object)Integer.valueOf((int)fileId))._ext;
    }

    public long getFileSize(int fileId) {
        assert (this._fileIdToInfoMapping.get(fileId) != null);
        return this._fileIdToInfoMapping.get((Object)Integer.valueOf((int)fileId))._size;
    }

    private class FileInfo {
        public final String _ext;
        public final long _size;

        public FileInfo(String ext, long size) {
            this._ext = ext;
            this._size = size;
        }
    }
}

