/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.hash.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.ac.osaka_u.ist.sel.similarity.database.AbstractDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.database.SQLGenerator;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;
import org.apache.log4j.Logger;

public class InsertionHashInfoDAO
extends AbstractDAO {
    Logger _log = Logger.getLogger(InsertionHashInfoDAO.class);

    public InsertionHashInfoDAO(TransactionManager transactionManager) throws SQLException {
        super(transactionManager);
    }

    public boolean insert(int fileId, byte[] digest) throws SQLException {
        if (this.exists(fileId)) {
            String message = "ID '" + fileId + "' has been already registered.";
            this._log.warn((Object)message);
            return false;
        }
        PreparedStatement pstmt = null;
        String sql = "insert into " + (Object)((Object)TableType.HASH_INFO) + " values (?,?)";
        pstmt = this.prepareStatement(sql);
        pstmt.setInt(1, fileId);
        pstmt.setBytes(2, digest);
        return this.executeUpdate(pstmt) == 1;
    }

    private boolean exists(int fileId) throws SQLException {
        ColumnName[] columns = new ColumnName[]{ColumnName.ID};
        String sql = SQLGenerator.getWhereSelectStatement(TableType.HASH_INFO, columns, ColumnName.ID, String.valueOf(fileId));
        PreparedStatement pstmt = this.prepareStatement(sql);
        ResultSet results = this.executeQuery(pstmt);
        return results.next();
    }
}

