/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.hash.database;

import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import jp.ac.osaka_u.ist.sel.similarity.commons.Settings;
import jp.ac.osaka_u.ist.sel.similarity.database.DatabaseCreationDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;
import jp.ac.osaka_u.ist.sel.similarity.hash.database.InsertionHashInfoDAO;
import jp.ac.osaka_u.ist.sel.similarity.hash.database.InsertionTokenInfoDAO;
import jp.ac.osaka_u.ist.sel.similarity.hash.database.SelectionFileDAO;

public class HashRegisterDAOManager {
    private TransactionManager _transactionManager;
    private SelectionFileDAO _fileDAO;
    private InsertionHashInfoDAO _hashDAO;
    private InsertionTokenInfoDAO _tokenDAO;

    public HashRegisterDAOManager(String dbPath) throws SQLException {
        this._transactionManager = new TransactionManager(dbPath);
        this._fileDAO = new SelectionFileDAO(this._transactionManager);
        DatabaseCreationDAO creationDAO = new DatabaseCreationDAO(this._transactionManager);
        if (Settings.getInstance().getWorkingPath() != null) {
            try {
                creationDAO.createTokenInfo();
            }
            catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._tokenDAO = new InsertionTokenInfoDAO(this._transactionManager);
        }
        try {
            creationDAO.createHashInfo();
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._hashDAO = new InsertionHashInfoDAO(this._transactionManager);
    }

    public SelectionFileDAO getFileDAO() {
        return this._fileDAO;
    }

    public InsertionHashInfoDAO getHashDAO() {
        return this._hashDAO;
    }

    public InsertionTokenInfoDAO getTokenDAO() {
        return this._tokenDAO;
    }

    public void close() throws SQLException {
        this._transactionManager.close();
    }
}

