/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.hash;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import jp.ac.osaka_u.ist.sel.similarity.commons.Settings;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;
import jp.ac.osaka_u.ist.sel.similarity.hash.HashRegisterMain;
import org.apache.log4j.BasicConfigurator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HashRegisterMainTest {
    private static String _dbname = Settings._defaultDatabasePath;
    private static String _workspace = "FC_TMP";
    String _cpp1 = "../fc-resources/resource/testdata/cpp";
    String _cpp2 = "../fc-resources/resource/testdata/cpp/failed";
    String _cpp3 = "../fc-resources/resource/testdata/cpp/httpd-2.2.19";
    String _cpp4 = "../fc-resources/resource/testdata/cpp/freebsd-ports";
    String _java1 = "src";
    String _java2 = "testcase";
    String _java3 = "../fc-resources/resource/testdata/java";
    String _java4 = "../fc-resources/resource/testdata/java/failed";
    String _txt1 = "../fc-resources/resource/testdata/txt";

    @Before
    public void setUp() throws Exception {
        BasicConfigurator.configure();
        if (!HashRegisterMainTest.dropTable(TableType.HASH_INFO)) {
            System.err.println("Not yet implemented");
        }
        if (!HashRegisterMainTest.dropTable(TableType.TOKEN_INFO)) {
            System.err.println("Not yet implemented");
        }
        if (!HashRegisterMainTest.dropTable(TableType.FILE_INFO)) {
            System.err.println("Not yet implemented");
        }
        if (!HashRegisterMainTest.dropTable(TableType.DOMAIN_INFO)) {
            System.err.println("Not yet implemented");
        }
    }

    private static boolean dropTable(TableType tableType) throws SQLException {
        TransactionManager transactionManager = null;
        try {
            transactionManager = new TransactionManager(_dbname);
            String sql = "DROP TABLE " + (Object)((Object)tableType);
            PreparedStatement pstmt = transactionManager.prepareStatement(sql);
            if (transactionManager.executeUpdate(pstmt) != 0) {
                return false;
            }
        }
        catch (SQLSyntaxErrorException e) {
            return false;
        }
        finally {
            if (transactionManager != null) {
                try {
                    transactionManager.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
        return true;
    }

    @Test
    public void testMain1_1() {
        String[] args = new String[]{"-jdb", _dbname, "-l", "JAVA", "-d", this._java1, this._java2, this._txt1};
        try {
            HashRegisterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain1_2() {
        String[] args = new String[]{"-w", _workspace, "-jdb", _dbname, "-l", "JAVA", "-d", this._java1, this._java2, this._txt1};
        try {
            HashRegisterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain1_3() {
        String[] args = new String[]{"-jdb", _dbname, "-l", "JAVA", "-a", "-d", this._java1, this._java2, this._txt1};
        try {
            HashRegisterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain1_4() {
        String[] args = new String[]{"-w", _workspace, "-jdb", _dbname, "-a", "-d", this._java1, this._java2, this._txt1};
        try {
            HashRegisterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain2_1() {
        String[] args = new String[]{"-w", _workspace, "-jdb", _dbname, "-l", "CPP", "-d", this._cpp3};
        try {
            HashRegisterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain2_2() {
        String[] args = new String[]{"-jdb", _dbname, "-l", "CPP", "-d", this._cpp3};
        try {
            HashRegisterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain3() {
        String[] args = new String[]{"-w", _workspace, "-jdb", _dbname, "-l", "CPP", "-d", this._cpp1};
        try {
            HashRegisterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain4() {
        String[] args = new String[]{"-w", _workspace, "-jdb", _dbname, "-l", "CPP", "-d", this._cpp2};
        try {
            HashRegisterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain5_1() {
        String[] args = new String[]{"-w", _workspace, "-jdb", _dbname, "-l", "JAVA", "-d", this._java3};
        try {
            HashRegisterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain5_2() {
        String[] args = new String[]{"-jdb", _dbname, "-l", "JAVA", "-d", this._java3};
        try {
            HashRegisterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain6() {
        String[] args = new String[]{"-w", _workspace, "-jdb", _dbname, "-l", "JAVA", "-d", this._java4};
        try {
            HashRegisterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }

    @Test
    public void testMain7() {
        String[] args = new String[]{"-w", _workspace, "-jdb", _dbname, "-l", "CPP", "-d", this._cpp4};
        try {
            HashRegisterMain.main(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"catch a SQLException");
        }
    }
}

