/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.hash;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.similarity.commons.MD5Digest;
import jp.ac.osaka_u.ist.sel.similarity.commons.Settings;
import jp.ac.osaka_u.ist.sel.similarity.commons.SupportedLanguage;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.hash.database.HashRegisterDAOManager;
import jp.ac.osaka_u.ist.sel.similarity.hash.database.InsertionHashInfoDAO;
import jp.ac.osaka_u.ist.sel.similarity.hash.database.InsertionTokenInfoDAO;
import jp.ac.osaka_u.ist.sel.similarity.hash.database.SelectionFileDAO;
import jp.ac.osaka_u.ist.sel.similarity.hash.tokenizer.CppTokenInfoRegister;
import jp.ac.osaka_u.ist.sel.similarity.hash.tokenizer.JavaTokenInfoRegister;
import jp.ac.osaka_u.ist.sel.similarity.hash.tokenizer.TokenInfoRegister;
import org.apache.log4j.Logger;

public class HashInfoRegister {
    private final Logger _log = Logger.getLogger((String)"HashInfoRegister");
    private final SelectionFileDAO _fileDAO;
    private final InsertionHashInfoDAO _hashDAO;
    private final InsertionTokenInfoDAO _tokenDAO;

    public HashInfoRegister(HashRegisterDAOManager daoManager) {
        this._fileDAO = daoManager.getFileDAO();
        this._hashDAO = daoManager.getHashDAO();
        this._tokenDAO = daoManager.getTokenDAO();
    }

    public void clusterFile() {
        HashMap<String, HashSet<Integer>> extMap = new HashMap<String, HashSet<Integer>>();
        for (int fileId : this._fileDAO.getFileIdSet()) {
            String ext = this._fileDAO.getFileExt(fileId);
            HashSet<Integer> fileIdSet = (HashSet<Integer>)extMap.get(ext);
            if (fileIdSet == null) {
                fileIdSet = new HashSet<Integer>();
            }
            fileIdSet.add(fileId);
            extMap.put(ext, fileIdSet);
        }
        for (String ext : extMap.keySet()) {
            String lang = SupportedLanguage.getTargetLanguage(ext);
            TokenInfoRegister register = this.getTokenInfoRegister(lang);
            Set<Integer> fileIdSet = (Set<Integer>)extMap.get(ext);
            if (register != null) {
                this.calculateHash(fileIdSet, register);
                continue;
            }
            fileIdSet = this.collectSizeCluster(fileIdSet);
            this.calculateHash(fileIdSet);
        }
    }

    private Set<Integer> collectSizeCluster(Set<Integer> fileIdSet) {
        HashMap<Long, HashSet<Integer>> sizeMap = new HashMap<Long, HashSet<Integer>>();
        for (int fileId : fileIdSet) {
            long size = this._fileDAO.getFileSize(fileId);
            HashSet<Integer> fileIdSubSet = (HashSet<Integer>)sizeMap.get(size);
            if (fileIdSubSet == null) {
                fileIdSubSet = new HashSet<Integer>();
            }
            fileIdSubSet.add(fileId);
            sizeMap.put(size, fileIdSubSet);
        }
        HashSet<Integer> fileIdSubSet = new HashSet<Integer>();
        Iterator iterator = sizeMap.keySet().iterator();
        while (iterator.hasNext()) {
            long size = (Long)iterator.next();
            Set fileIdCluster = (Set)sizeMap.get(size);
            if (fileIdCluster.size() <= 1) continue;
            fileIdSubSet.addAll(fileIdCluster);
        }
        return fileIdSubSet;
    }

    private TokenInfoRegister getTokenInfoRegister(String langoffile) {
        TokenInfoRegister register = null;
        Set<String> languages = Settings.getInstance().getTargetLanguages();
        if ("C".equals(langoffile) && (languages.contains("C") || languages.contains("CPP"))) {
            register = new CppTokenInfoRegister(this._tokenDAO);
        } else if ("CPP".equals(langoffile) && languages.contains("CPP")) {
            register = new CppTokenInfoRegister(this._tokenDAO);
        } else if ("JAVA".equals(langoffile) && languages.contains("JAVA")) {
            register = new JavaTokenInfoRegister(this._tokenDAO);
        }
        return register;
    }

    private void calculateHash(Set<Integer> fileIdSet) {
        for (int fileId : fileIdSet) {
            try {
                String filePath = this._fileDAO.getFilePath(fileId);
                byte[] digest = null;
                digest = MD5Digest.getFileDigest(filePath);
                if (digest != null) {
                    this.registerHash(fileId, digest);
                    continue;
                }
                this._log.error((Object)("Can not get hash:\t" + filePath));
            }
            catch (Throwable e) {
                this._log.error((Object)("hash detection error :\t" + fileId));
                this._log.error((Object)e.getMessage(), e);
            }
        }
    }

    private void calculateHash(Set<Integer> fileIdSet, TokenInfoRegister register) {
        for (int fileId : fileIdSet) {
            try {
                String filePath = this._fileDAO.getFilePath(fileId);
                byte[] digest = null;
                digest = register.calculateHash(fileId, filePath);
                if (digest != null) {
                    this.registerHash(fileId, digest);
                    continue;
                }
                this._log.error((Object)("Can not get hash:\t" + filePath));
            }
            catch (Throwable e) {
                this._log.error((Object)("hash detection error :\t" + fileId));
                this._log.error((Object)e.getMessage(), e);
            }
        }
    }

    private void registerHash(int fileId, byte[] md5digest) throws SQLException {
        assert (md5digest.length <= ColumnName.getColumnLength(ColumnName.MD5_HASH));
        if (!this._hashDAO.insert(fileId, md5digest)) {
            this._log.error((Object)("Can not register digest:\t" + fileId));
            return;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("register digest:\t" + fileId));
        }
    }
}

