/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.fileclone.register;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.similarity.fileclone.database.CloneRegisterDAOManager;
import jp.ac.osaka_u.ist.sel.similarity.fileclone.database.InsertionCloneInfoDAO;
import jp.ac.osaka_u.ist.sel.similarity.fileclone.database.SelectionHashDAO;
import org.apache.log4j.Logger;

public class CloneInfoRegister {
    private Logger _log = Logger.getLogger((String)"CloneInfoRegister");
    private final InsertionCloneInfoDAO _filecloneDAO;
    private final SelectionHashDAO _hashDAO;

    public CloneInfoRegister(CloneRegisterDAOManager daoManager) throws SQLException {
        this._hashDAO = daoManager.getHashDAO();
        this._filecloneDAO = daoManager.getFileCloneDAO();
    }

    public void execute() throws Exception {
        Map<List<Byte>, Set<Integer>> fileIdToHashValue = this._hashDAO.getHashToIdMapping();
        int groupId = 1;
        for (List<Byte> hash : fileIdToHashValue.keySet()) {
            Set<Integer> files = fileIdToHashValue.get(hash);
            if (files.size() < 2) continue;
            for (Integer fileId : files) {
                this.registerCloneInfo(fileId, groupId);
            }
            ++groupId;
        }
    }

    private void registerCloneInfo(int fileId, int groupId) throws SQLException {
        if (!this._filecloneDAO.insertData(fileId, groupId)) {
            this._log.error((Object)("Failed to register: " + fileId));
        }
    }
}

