/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.fileclone.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.ac.osaka_u.ist.sel.similarity.database.AbstractDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.database.SQLGenerator;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

public class SelectionHashDAO
extends AbstractDAO {
    private Map<List<Byte>, Set<Integer>> _hashToFileIdMapping = new HashMap<List<Byte>, Set<Integer>>();

    public SelectionHashDAO(TransactionManager transactionManager) throws SQLException {
        super(transactionManager);
        this.initializeHashToIdMapping();
    }

    private void initializeHashToIdMapping() throws SQLException {
        ColumnName[] columns = new ColumnName[]{ColumnName.ID, ColumnName.MD5_HASH};
        String sql = SQLGenerator.getSelectStatement(TableType.HASH_INFO, columns);
        PreparedStatement pstmt = this.prepareStatement(sql);
        ResultSet results = this.executeQuery(pstmt);
        while (results.next()) {
            ArrayList<Byte> hashValue = new ArrayList<Byte>();
            byte[] byArray = results.getBytes(2);
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte hashElement = byArray[n2];
                hashValue.add(hashElement);
                ++n2;
            }
            int fileId = results.getInt(1);
            Set<Integer> files = this._hashToFileIdMapping.get(hashValue);
            if (files == null) {
                files = new HashSet<Integer>();
            }
            files.add(fileId);
            this._hashToFileIdMapping.put(hashValue, files);
        }
    }

    public Map<List<Byte>, Set<Integer>> getHashToIdMapping() throws SQLException {
        return this._hashToFileIdMapping;
    }
}

