/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class TransactionManager {
    private final Logger _log = Logger.getLogger((String)"TransactionManager");
    private String _dbPath;
    private Connection _conn;
    private int _transactionCount = 0;
    private static final int _TRANSACTION_MAX_COUNT = 10000;

    public TransactionManager(String dbPath) {
        try {
            this._dbPath = dbPath;
            this.getConnection();
        }
        catch (SQLException e) {
            this._log.error((Object)"Failed to access the database.");
            this._log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void commit() throws SQLException {
        this.getConnection();
        try {
            this._conn.commit();
        }
        catch (SQLException e) {
            this._log.error((Object)"A rollback has occured.");
            this._conn.rollback();
            throw e;
        }
    }

    public synchronized void close() throws SQLException {
        this.getConnection();
        try {
            this.commit();
        }
        finally {
            if (this._conn != null) {
                this._conn.close();
            }
        }
    }

    public synchronized ResultSet executeQuery(PreparedStatement pstmt) throws SQLException {
        ResultSet rset = pstmt.executeQuery();
        return rset;
    }

    public synchronized int executeUpdate(PreparedStatement pstmt) throws SQLException {
        int executed = pstmt.executeUpdate();
        if (this._transactionCount++ > 10000) {
            this._transactionCount = 0;
            this.commit();
        }
        return executed;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.getConnection();
        return this._conn.prepareStatement(sql);
    }

    private void getConnection() throws SQLException {
        if (this._conn == null || this._conn.isClosed()) {
            Connection conn;
            File dbFile = new File(this._dbPath);
            if (dbFile.getParentFile() != null && !dbFile.getParentFile().exists()) {
                throw new RuntimeException("no such directory:\t" + dbFile.getParent());
            }
            this._conn = conn = DriverManager.getConnection("jdbc:derby:" + this._dbPath + ";create=true");
            this._conn.setAutoCommit(false);
            this._conn.setSavepoint();
        }
    }
}

