/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.database;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import jp.ac.osaka_u.ist.sel.similarity.database.DatabaseCreationDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DatabaseCreationDAOTest {
    private static String _dbname = "TestDatabase";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        if (!DatabaseCreationDAOTest.dropTable(TableType.CLONE_INFO)) {
            System.err.println("Not yet implemented");
        }
        if (!DatabaseCreationDAOTest.dropTable(TableType.HASH_INFO)) {
            System.err.println("Not yet implemented");
        }
        if (!DatabaseCreationDAOTest.dropTable(TableType.TOKEN_INFO)) {
            System.err.println("Not yet implemented");
        }
        if (!DatabaseCreationDAOTest.dropTable(TableType.FILE_INFO)) {
            System.err.println("Not yet implemented");
        }
        if (!DatabaseCreationDAOTest.dropTable(TableType.DOMAIN_INFO)) {
            System.err.println("Not yet implemented");
        }
    }

    private static boolean dropTable(TableType tableType) throws SQLException {
        TransactionManager transactionManager = null;
        try {
            transactionManager = new TransactionManager(_dbname);
            String sql = "DROP TABLE " + (Object)((Object)tableType);
            PreparedStatement pstmt = transactionManager.prepareStatement(sql);
            if (transactionManager.executeUpdate(pstmt) != 0) {
                return false;
            }
        }
        catch (SQLSyntaxErrorException e) {
            return false;
        }
        finally {
            if (transactionManager != null) {
                try {
                    transactionManager.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
        return true;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Test
    public void testCreateDomainInfo() throws SQLException {
        TransactionManager transactionManager = null;
        try {
            transactionManager = new TransactionManager(_dbname);
            DatabaseCreationDAO creationDAO = new DatabaseCreationDAO(transactionManager);
            if (!creationDAO.createDomainInfo()) {
                Assert.fail((String)"Not yet implemented");
            }
        }
        finally {
            if (transactionManager != null) {
                try {
                    transactionManager.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
    }

    @Test
    public void testCreateFileInfo() throws SQLException {
        TransactionManager transactionManager = null;
        try {
            transactionManager = new TransactionManager(_dbname);
            DatabaseCreationDAO creationDAO = new DatabaseCreationDAO(transactionManager);
            if (!creationDAO.createFileInfo()) {
                Assert.fail((String)"Not yet implemented");
            }
        }
        finally {
            if (transactionManager != null) {
                try {
                    transactionManager.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
    }

    @Test
    public void testCreateTokenInfo() throws SQLException {
        TransactionManager transactionManager = null;
        try {
            transactionManager = new TransactionManager(_dbname);
            DatabaseCreationDAO creationDAO = new DatabaseCreationDAO(transactionManager);
            if (!creationDAO.createTokenInfo()) {
                Assert.fail((String)"Not yet implemented");
            }
        }
        finally {
            if (transactionManager != null) {
                try {
                    transactionManager.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
    }

    @Test
    public void testCreateHashInfo() throws SQLException {
        TransactionManager transactionManager = null;
        try {
            transactionManager = new TransactionManager(_dbname);
            DatabaseCreationDAO creationDAO = new DatabaseCreationDAO(transactionManager);
            if (!creationDAO.createHashInfo()) {
                Assert.fail((String)"Not yet implemented");
            }
        }
        finally {
            if (transactionManager != null) {
                try {
                    transactionManager.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
    }

    @Test
    public void testCreateCloneInfo() throws SQLException {
        TransactionManager transactionManager = null;
        try {
            transactionManager = new TransactionManager(_dbname);
            DatabaseCreationDAO creationDAO = new DatabaseCreationDAO(transactionManager);
            if (!creationDAO.createCloneInfo()) {
                Assert.fail((String)"Not yet implemented");
            }
        }
        finally {
            if (transactionManager != null) {
                try {
                    transactionManager.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
    }
}

