/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.database;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import jp.ac.osaka_u.ist.sel.similarity.database.AbstractDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

public class DatabaseCreationDAO
extends AbstractDAO {
    public DatabaseCreationDAO(TransactionManager transactionManager) throws SQLException {
        super(transactionManager);
    }

    public boolean createDomainInfo() throws SQLException {
        String sql = "CREATE TABLE " + (Object)((Object)TableType.DOMAIN_INFO) + " (" + (Object)((Object)ColumnName.ID) + " " + ColumnName.getColumnType(ColumnName.ID) + " NOT NULL PRIMARY KEY, " + (Object)((Object)ColumnName.NAME) + " " + ColumnName.getColumnType(ColumnName.NAME) + " NOT NULL)";
        PreparedStatement pstmt = this.prepareStatement(sql);
        if (this.executeUpdate(pstmt) == 0) {
            boolean createIndex = this.createIndex(TableType.DOMAIN_INFO, ColumnName.ID);
            return createIndex;
        }
        return false;
    }

    public boolean createFileInfo() throws SQLException {
        String sql = "CREATE TABLE " + (Object)((Object)TableType.FILE_INFO) + " (" + (Object)((Object)ColumnName.ID) + " " + ColumnName.getColumnType(ColumnName.ID) + " NOT NULL PRIMARY KEY, " + (Object)((Object)ColumnName.PATH) + " " + ColumnName.getColumnType(ColumnName.PATH) + " NOT NULL, " + (Object)((Object)ColumnName.EXT) + " " + ColumnName.getColumnType(ColumnName.EXT) + " NOT NULL, " + (Object)((Object)ColumnName.FILE_SIZE) + " " + ColumnName.getColumnType(ColumnName.FILE_SIZE) + " NOT NULL, " + (Object)((Object)ColumnName.DOMAIN_ID) + " " + ColumnName.getColumnType(ColumnName.DOMAIN_ID) + " NOT NULL, " + "FOREIGN KEY (" + (Object)((Object)ColumnName.DOMAIN_ID) + ") REFERENCES " + (Object)((Object)TableType.DOMAIN_INFO) + "(" + (Object)((Object)ColumnName.ID) + "))";
        PreparedStatement pstmt = this.prepareStatement(sql);
        if (this.executeUpdate(pstmt) == 0) {
            boolean createIndex = this.createIndex(TableType.FILE_INFO, ColumnName.ID);
            return createIndex;
        }
        return false;
    }

    public boolean createTokenInfo() throws SQLException {
        String sql = "CREATE TABLE " + (Object)((Object)TableType.TOKEN_INFO) + " (" + (Object)((Object)ColumnName.ID) + " " + ColumnName.getColumnType(ColumnName.ID) + " NOT NULL PRIMARY KEY, " + (Object)((Object)ColumnName.PATH) + " " + ColumnName.getColumnType(ColumnName.PATH) + " NOT NULL, " + (Object)((Object)ColumnName.NUM_OF_TOK) + " " + ColumnName.getColumnType(ColumnName.NUM_OF_TOK) + " NOT NULL, " + (Object)((Object)ColumnName.FILE_SIZE) + " " + ColumnName.getColumnType(ColumnName.FILE_SIZE) + " NOT NULL, " + "FOREIGN KEY (" + (Object)((Object)ColumnName.ID) + ") REFERENCES " + (Object)((Object)TableType.FILE_INFO) + "(" + (Object)((Object)ColumnName.ID) + "))";
        PreparedStatement pstmt = this.prepareStatement(sql);
        if (this.executeUpdate(pstmt) == 0) {
            boolean createIndex = this.createIndex(TableType.TOKEN_INFO, ColumnName.FILE_SIZE);
            return createIndex;
        }
        return false;
    }

    public boolean createHashInfo() throws SQLException {
        String sql = "CREATE TABLE " + (Object)((Object)TableType.HASH_INFO) + " (" + (Object)((Object)ColumnName.ID) + " " + ColumnName.getColumnType(ColumnName.ID) + " NOT NULL PRIMARY KEY, " + (Object)((Object)ColumnName.MD5_HASH) + " " + ColumnName.getColumnType(ColumnName.MD5_HASH) + " NOT NULL, " + "FOREIGN KEY (" + (Object)((Object)ColumnName.ID) + ") REFERENCES " + (Object)((Object)TableType.FILE_INFO) + "(" + (Object)((Object)ColumnName.ID) + "))";
        PreparedStatement pstmt = this.prepareStatement(sql);
        if (this.executeUpdate(pstmt) == 0) {
            boolean createIndex = this.createIndex(TableType.HASH_INFO, ColumnName.MD5_HASH);
            return createIndex;
        }
        return false;
    }

    public boolean createCloneInfo() throws SQLException {
        String sql = "CREATE TABLE " + (Object)((Object)TableType.CLONE_INFO) + " (" + (Object)((Object)ColumnName.ID) + " " + ColumnName.getColumnType(ColumnName.ID) + " NOT NULL PRIMARY KEY, " + (Object)((Object)ColumnName.GROUP_ID) + " " + ColumnName.getColumnType(ColumnName.GROUP_ID) + " NOT NULL, " + "FOREIGN KEY (" + (Object)((Object)ColumnName.ID) + ") REFERENCES " + (Object)((Object)TableType.FILE_INFO) + "(" + (Object)((Object)ColumnName.ID) + "))";
        PreparedStatement pstmt = this.prepareStatement(sql);
        if (this.executeUpdate(pstmt) == 0) {
            boolean createIndex = this.createIndex(TableType.CLONE_INFO, ColumnName.GROUP_ID);
            return createIndex;
        }
        return false;
    }

    public boolean createFileManageInfo() throws SQLException {
        String sql = "CREATE TABLE " + (Object)((Object)TableType.FILE_MANAGE_INFO) + " (" + (Object)((Object)ColumnName.ID) + " " + ColumnName.getColumnType(ColumnName.ID) + " NOT NULL PRIMARY KEY, " + (Object)((Object)ColumnName.MODIFIED) + " " + ColumnName.getColumnType(ColumnName.MODIFIED) + " NOT NULL, " + "FOREIGN KEY (" + (Object)((Object)ColumnName.ID) + ") REFERENCES " + (Object)((Object)TableType.FILE_INFO) + "(" + (Object)((Object)ColumnName.ID) + "))";
        PreparedStatement pstmt = this.prepareStatement(sql);
        if (this.executeUpdate(pstmt) == 0) {
            boolean createIndex = this.createIndex(TableType.FILE_MANAGE_INFO, ColumnName.MODIFIED);
            return createIndex;
        }
        return false;
    }

    private boolean createIndex(TableType table, ColumnName column) throws SQLException {
        String sql = "CREATE INDEX IDX_" + (Object)((Object)table) + "_" + (Object)((Object)column) + " ON " + (Object)((Object)table) + "(" + (Object)((Object)column) + ")";
        PreparedStatement pstmt = this.prepareStatement(sql);
        return this.executeUpdate(pstmt) == 0;
    }
}

