/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.osaka_u.ist.sel.similarity.csv.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.ac.osaka_u.ist.sel.similarity.csv.database.object.FileCsvInfo;
import jp.ac.osaka_u.ist.sel.similarity.database.AbstractDAO;
import jp.ac.osaka_u.ist.sel.similarity.database.ColumnName;
import jp.ac.osaka_u.ist.sel.similarity.database.SQLGenerator;
import jp.ac.osaka_u.ist.sel.similarity.database.TableType;
import jp.ac.osaka_u.ist.sel.similarity.database.TransactionManager;

public class SelectionFileDAO
extends AbstractDAO {
    public SelectionFileDAO(TransactionManager transactionManager) throws SQLException {
        super(transactionManager);
    }

    public FileCsvInfo getData(int fileId) throws SQLException {
        FileCsvInfo fileInfo = null;
        ColumnName[] columns = new ColumnName[]{ColumnName.PATH, ColumnName.EXT, ColumnName.FILE_SIZE, ColumnName.DOMAIN_ID};
        String sql = SQLGenerator.getWhereSelectStatement(TableType.FILE_INFO, columns, ColumnName.ID, String.valueOf(fileId));
        PreparedStatement pstmt = this.prepareStatement(sql);
        ResultSet results = this.executeQuery(pstmt);
        if (!results.next()) {
            return null;
        }
        String path = results.getString(1);
        String ext = results.getString(2);
        long size = results.getLong(3);
        int domainId = results.getInt(4);
        fileInfo = new FileCsvInfo(fileId, path, ext, size, domainId);
        return fileInfo;
    }
}

